function [locData] = rainSTORM_main(imageStack, method, locAlgoSettings, parforFlag)

% required functions:
% rainSTORM/localization/rainSTORM_default_settings_loc_algos.m
% rainSTORM/localization/rainSTORM_main_loop.m
% rainSTORM/localization/rainSTORM_avNMS.m
% rainSTORM/localization/rainSTORM_fitLocGF_2D_constBg.m
% rainSTORM/localization/rainSTORM_parfor_progress.m

locAlgoName=method;

% convert the settings given in nm to camera pixel size:
cameraSignalConversion = locAlgoSettings.cameraSignalConversion;
if isfield(locAlgoSettings, 'Thresh')
    Thresh = unitConversion.convertScalarQuantity(locAlgoSettings.Thresh, 'camera count', cameraSignalConversion);
    locAlgoSettings.Thresh = Thresh.value;
end
if isfield(locAlgoSettings, 'allowSig')
   allowSig = unitConversion.convertScalarQuantity(locAlgoSettings.allowSig, 'camera pixel length', cameraSignalConversion);
   locAlgoSettings.allowSig = allowSig.value;
end
if isfield(locAlgoSettings, 'allowX')
    allowX = unitConversion.convertScalarQuantity(locAlgoSettings.allowX, 'camera pixel length', cameraSignalConversion);
    locAlgoSettings.allowX = allowX.value;
end
if isfield(locAlgoSettings, 'initSig')
    initSig = unitConversion.convertScalarQuantity(locAlgoSettings.initSig, 'camera pixel length', cameraSignalConversion);
    locAlgoSettings.initSig = initSig.value;
end
if isfield(locAlgoSettings, 'rad')
    rad = unitConversion.convertScalarQuantity(locAlgoSettings.rad, 'camera pixel length', cameraSignalConversion);
    locAlgoSettings.rad = max(round(rad.value), 0);
end


algo_names_and_handles.names = {...
    'LS Multi Gaussian 2D linear Bg';...
    'LS Multi Astigmatic Gaussian 2D linear Bg';...
    'LS Multi Gaussian 2D const Bg';...
    'LS Gaussian 2D linear Bg';...
    'LS Astigmatic Gaussian 2D linear Bg';...
    'LS Gaussian 2D const Bg';...
    'LS Astigmatic Gaussian 2D const Bg';...
    'LS Gaussian Halt3';...
    'LS Gaussian Thorough';...
    'Centre of Mass';...
    'Test Algo'};
algo_names_and_handles.fhandle = {...
    @(frameIdx, myFrame,myPixels,settings)rainSTORM_fitLocMultiGF_2D_linearBg(frameIdx, myFrame,myPixels,settings);...
    @(frameIdx, myFrame,myPixels,settings)rainSTORM_fitLocMultiAstGF_2D_linearBg(frameIdx, myFrame,myPixels,settings);...
    @(frameIdx, myFrame,myPixels,settings)rainSTORM_fitLocMultiGF_2D_constBg(frameIdx, myFrame,myPixels,settings);...
    @(frameIdx, myFrame,myPixels,settings)rainSTORM_fitLocGF_2D_linearBg(frameIdx, myFrame,myPixels,settings);...
    @(frameIdx, myFrame,myPixels,settings)rainSTORM_fitLocAstGF_2D_linearBg(frameIdx, myFrame,myPixels,settings);...
    @(frameIdx, myFrame,myPixels,settings)rainSTORM_fitLocGF_2D_constBg(frameIdx, myFrame,myPixels,settings);...
    @(frameIdx, myFrame,myPixels,settings)rainSTORM_fitLocAstGF_2D_constBg(frameIdx, myFrame,myPixels,settings);...
    @(frameIdx, myFrame,myPixels,settings)rainSTORM_fitLocGF3(frameIdx, myFrame,myPixels,settings);...
    @(frameIdx, myFrame,myPixels,settings)rainSTORM_fitLocGF(frameIdx, myFrame,myPixels,settings);...
    @(frameIdx, myFrame,myPixels,rad)rainSTORM_fitCoM(frameIdx, myFrame,myPixels,rad);...
    @(frameIdx, myFrame,myPixels,settings)rainSTORM_fitLocGF3(frameIdx, myFrame,myPixels,settings)};

algo_handle = algo_names_and_handles.fhandle{...
    strcmp(algo_names_and_handles.names,locAlgoName)==1};

% go through the frames and localize them
numberOfFrames=size(imageStack, 3);
clear parfor_progress_2
parfor_progress(numberOfFrames);

% divide the locallization process into sections. 
sectionFrameN=100;
sectionN=ceil(numberOfFrames/sectionFrameN);
lastSectionFrameN=mod(numberOfFrames, sectionFrameN);
if lastSectionFrameN==0
    lastSectionFrameN=sectionFrameN;
end

sectionDataCell=cell(sectionN,1);
lastFrameIndex=0;
for idxSection=1:sectionN
    
    if idxSection==sectionN
        actualSectionFrameN=lastSectionFrameN;
    else
        actualSectionFrameN=sectionFrameN;
    end
    
    SupResParams=[];
    if parforFlag
        parfor lpIm=lastFrameIndex+1:lastFrameIndex+actualSectionFrameN
            frame_to_process=imageStack(:,:,lpIm);
            SRP = rainSTORM_main_loop(lpIm, frame_to_process,algo_handle,locAlgoSettings);
            SupResParams = [SupResParams, SRP];
            parfor_progress;
        end
    else
        for lpIm=lastFrameIndex+1:lastFrameIndex+actualSectionFrameN
            frame_to_process=imageStack(:,:,lpIm);
            SRP = rainSTORM_main_loop(lpIm, frame_to_process,algo_handle,locAlgoSettings);
            SupResParams = [SupResParams, SRP];
            parfor_progress;
        end
    end
    
    
    % creating a table from the structure array
    if ~isempty(SupResParams)
        sectionDataCell{idxSection}=struct2table(SupResParams);
    end
    
    % or creating structure containing arrays from the structure array
%     sectionDataCell{idxSection}=struct();
%     fieldNames=fieldnames(SupResParams);
%     for idxField=1:numel(fieldNames)
%         sectionDataCell{idxSection}.(fieldNames{idxField})=transpose([SupResParams.(fieldNames{idxField})]);
%     end
    
    lastFrameIndex=lastFrameIndex+actualSectionFrameN;
    
    
end
parfor_progress(0);

% creating a table from the structure array
locData=cat(1, sectionDataCell{:});

% or creating structure containing arrays from the structure array
% TODO: it is not so straightforward with structures... 
% fieldNames=fieldnames(sectionDataCell{1});
% for idxField=1:numel(fieldNames)
%     locData.(fieldNames{idxField})=cat(1, sectionDataCell{:} %TODO );
% end

end

