function SupResParams = rainSTORM_main_loop(frameIdx,Frame,algo_handle,settings)

rad = settings.rad;
Thresh = settings.Thresh;
ImageFilter = settings.ImageFilter;

% 1. Identify local maxima above threshold, and return [row,col,magnitude]
H = fspecial('gaussian',5, 1);
filteredFrame = imfilter(Frame,H,'replicate');
myPixels = rainSTORM_avNMS(filteredFrame,rad,ImageFilter);

% 2. Thresholding. To remove noise maxima and weak signals.
myPixels((myPixels(:,3))<Thresh,:)=[]; % Apply threshold
myPixels = flipud(sortrows(myPixels,3)); % Sort for human-readability


% 3. Estimating background noise std
%    (Old approach: "bkgdSig = std(double(Frame(Frame < mean(Frame(:))))); % Avoids signal")
Frame = double(Frame);
noiseImage = Frame - imfilter( Frame, fspecial('gaussian', 15, 2.0 ), 'replicate' );
bkgdSig = std( noiseImage(:) );


% 4. Thresholding 2 - Remove candidates of low peak value compared to
%    bkgdSig
thresh2 = settings.Thresh2;
nMyPixels = size( myPixels, 1 );
for i = nMyPixels:-1:1
    roi = Frame( myPixels(i,1)-rad:myPixels(i,1)+rad, myPixels(i,2)-rad:myPixels(i,2)+rad );
    
    if roi(1+rad,1+rad) - min(roi(:)) < thresh2 * bkgdSig
        nMyPixels = nMyPixels - 1;
        myPixels(i, :) = [];
    end    
end
    

% 5. Localise centre of each pixellated blur (and reject if not Gaussian)
%Implement selected image processing algorithm.
SupResParams = algo_handle(frameIdx,Frame,myPixels,settings);

% 6. Assing a background noise level (frame "average")
for index=1:numel(SupResParams)
    SupResParams(index).backgroundSTD = single(bkgdSig);
end

% % % switch algo_name
% % %     case 'Least-Squares Gaussian Halt3'
% % %         SupResParams = rainSTORM_fitLocGF3(frameIdx,Frame,myPixels,bkgdSig,settings);
% % %     case 'Least-Squares Gaussian Thorough'
% % %         % Least squares Gaussian Fitting without halting
% % %         SupResParams = rainSTORM_fitLocGF(frameIdx,Frame,myPixels,bkgdSig,settings);
% % %     case 'Centre of Mass'
% % %         % Or fit by Centre of Mass: find 1st+2nd moment of intensity
% % %         SupResParams = rainSTORM_fitCoM(frameIdx,Frame,myPixels,bkgdSig,settings);
% % %     otherwise
% % %         error('Unknown localization algorithm.')
% % % end
end