function [imageMatrix, pixelCenters, metadata, sharedParameters] = rainSTORM_pixelization(pointillisticData, method, settings)


switch method
    case 'Simple Histogram'
        [imageMatrix, pixelCenters, pixelSize_nm] = rainSTORM_recon_counts(pointillisticData, settings);
    case 'Jittered Histogram'
        [imageMatrix, pixelCenters, pixelSize_nm] = rainSTORM_recon_JH(pointillisticData, settings);
    case 'Average Precision Image'
        [imageMatrix, pixelCenters, pixelSize_nm] = rainSTORM_recon_AVP(pointillisticData, settings);
    case 'Intensity Precision Image'
        [imageMatrix, pixelCenters, pixelSize_nm] = rainSTORM_recon_IP(pointillisticData, settings);
    otherwise
        error('')
end

metadata = struct([]);
sharedParameters.supResImagePixelizationMethod = method;
sharedParameters.supResImagePixelSize_nm = pixelSize_nm;

end

