function [imageMatrix, pixelCenters, pixelSize_nm] = rainSTORM_recon_AVP(pointillisticData,settings)

linMag = settings.linMag;
stackSize = settings.stackSize;
frameSize = [stackSize(1), stackSize(2)];
SupResPosits = double([pointillisticData.x_coord, pointillisticData.y_coord]);

pixelSize_nm = settings.cameraPixelSize_nm/linMag;

if pointillisticData_fieldNameManagement.isMemberField(pointillisticData, {'std_x', 'std_y'})
    std_x = pointillisticData.std_x;
    std_y = pointillisticData.std_y;
elseif pointillisticData_fieldNameManagement.isMemberField(pointillisticData, {'std'})
    std_x = pointillisticData.std;
    std_y = pointillisticData.std;
else
    warning('The localization data does not contain the localization precision. Cannot visualize the "average precision map".')
    return
end

nRows = frameSize(1)*linMag;  % Size of super-resolution reconstruction
nCols = frameSize(2)*linMag;
SupResImHist = uint16(zeros(nRows,nCols)); % 2^16 is unlikely to overflow

myPosits = SupResPosits*linMag; % Scale localisations to super-res grid
myPosits = ceil(myPosits);      % Digitise localisations to super-res grid

for lpSRI = 1:size(myPosits,1)
    SupResImHist( myPosits(lpSRI,1)  , myPosits(lpSRI,2)  ) = ...
        SupResImHist( myPosits(lpSRI,1)  , myPosits(lpSRI,2)  ) +1;
    % Elementwise binning. Not very elegant, I admit.
end % End of allocating dyes to pixels of the reconstruction

SupResImPrec = uint16(zeros(nRows,nCols)); % 2^16 is unlikely to overflow
deltaX = double([std_x, std_y]);

for lpSRI = 1:size(myPosits,1)
    SupResImPrec( myPosits(lpSRI,1)  , myPosits(lpSRI,2)  ) = ...
        SupResImPrec( myPosits(lpSRI,1)  , myPosits(lpSRI,2)  ) + deltaX(lpSRI,1);
    
end % End of allocating dyes to pixels of the reconstruction

% Divide sum of precisions by histogram image to produce a confidence
% image.
imageMatrix = (100*SupResImHist./SupResImPrec);

pixelCenters.x = (repmat(transpose(1:nRows), [1,nCols])-0.5) / linMag;
pixelCenters.y = (repmat(1:nCols, [nRows,1])-0.5) / linMag;
pixelCenters.unit = 'camera pixel length';

end


