function [imageMatrix, pixelCenters, pixelSize_nm] = rainSTORM_recon_IP(pointillisticData, settings)

linMag = settings.linMag;
stackSize = settings.stackSize;
frameSize = [stackSize(1), stackSize(2)];
SupResPosits = double([pointillisticData.x_coord, pointillisticData.y_coord]);

pixelSize_nm = settings.cameraPixelSize_nm/linMag;

if pointillisticData_fieldNameManagement.isMemberField(pointillisticData, {'std_x', 'std_y'})
    std_x = pointillisticData.std_x;
    std_y = pointillisticData.std_y;
elseif pointillisticData_fieldNameManagement.isMemberField(pointillisticData, {'std'})
    std_x = pointillisticData.std;
    std_y = pointillisticData.std;
else
    warning('The localization data does not contain the localization precision. Cannot visualize the "intensity precision map".')
    return
end

I = pointillisticData.sum_signal ./ (2*pi * std_x .* std_x);

nRows = frameSize(1)*linMag;  % Size of super-resolution reconstruction
nCols = frameSize(2)*linMag;
imageMatrix = uint16(zeros(nRows,nCols)); % 2^16 is unlikely to overflow

myPosits = SupResPosits*linMag; % Scale localisations to super-res grid
myPosits = ceil(myPosits);      % Digitise localisations to super-res grid

% fitPrecision = rainSTORM_precision(SupResParams);
fitPrecision = double([std_x, std_y]);
intensity = double(I) ./ fitPrecision(:,1);
for lpSRI = 1:size(myPosits,1)
    imageMatrix( myPosits(lpSRI,1)  , myPosits(lpSRI,2)  ) = ...
        imageMatrix( myPosits(lpSRI,1)  , myPosits(lpSRI,2)  ) + intensity(lpSRI,1);
end % End of allocating dyes to pixels of the reconstruction

pixelCenters.x = (repmat(transpose(1:nRows), [1,nCols])-0.5) / linMag;
pixelCenters.y = (repmat(1:nCols, [nRows,1])-0.5) / linMag;
pixelCenters.unit = 'camera pixel length';

end % End of rainSTORM_recon function, for STORM image reconstruction