function [imageMatrix, pixelCenters, pixelSize_nm] = rainSTORM_recon_counts(pointillisticData, settings)
%  Creates a simple histogram visualisation using localised positions
%  Note that the input arguments can be supplied as reviewedPosits etc.

linMag = settings.linMag;
stackSize = settings.stackSize;
frameSize = [stackSize(1), stackSize(2)];
SupResPosits = double([pointillisticData.x_coord, pointillisticData.y_coord]);

pixelSize_nm = settings.cameraPixelSize_nm/linMag;

nRows = ceil(frameSize(1)*linMag);   % Size of super-res reconstruction
nCols = ceil(frameSize(2)*linMag);   % Ceil() allows awkward scalings
imageMatrix = uint16(zeros(nRows,nCols)); % 2^16 is unlikely to overflow

myPosits = SupResPosits*linMag; % Scale localisations to super-res grid
myPosits = ceil(myPosits);      % Digitise localisations to super-res grid


for lpSRI = 1:size(myPosits,1)
    if ( myPosits(lpSRI,1)<1 || myPosits(lpSRI,2)<1 || ...
            myPosits(lpSRI,1)>nRows || myPosits(lpSRI,2)>nCols )
        continue; % Skip over positions if they are outside reconstruction (JH)
    end
    
    imageMatrix( myPosits(lpSRI,1)  , myPosits(lpSRI,2)  ) = ...
        imageMatrix( myPosits(lpSRI,1)  , myPosits(lpSRI,2)  ) +1;
    % Elementwise binning. Not very elegant, I admit.
end % End of allocating dyes to pixels of the reconstruction

pixelCenters.x = (repmat(transpose(1:nRows), [1,nCols])-0.5) / linMag;
pixelCenters.y = (repmat(1:nCols, [nRows,1])-0.5) / linMag;
pixelCenters.unit = 'camera pixel length';

end % End of rainSTORM_recon function, for STORM image reconstruction