function [filteredStack, backgroundStack, metadata, sharedParameters] = rainSTORM_backgroundRemoval(imageStack, method, settings)
% Simple moving median filter

switch method
    
    case 'moving median'
        
        frameRange=settings.frameRange;
        stackBaseline=settings.stackBaseline;
        
        [filteredStack, backgroundStack] = movingMedianFilter(imageStack, frameRange, stackBaseline);
        
        metadata = struct([]);
        sharedParameters = struct([]);
    case 'moving gaussian-weighted average'
        
        GaussianFWHM=settings.GaussianFWHM;
        stackBaseline=settings.stackBaseline;
        
        [filteredStack, backgroundStack, kernelRange] = movingGaussianAverage(imageStack, GaussianFWHM, stackBaseline);
        
        metadata = struct('kernelRange', kernelRange);
        sharedParameters = struct([]);
        
    otherwise
        
        warning(['The given method "', method, '" is not a valid backgroud subtraction algorithm in rainSTORM. Not performing any background removal.'])
        
        filteredStack = imageStack;
        backgroundStack = zeros(size(imageStack));
        
        metadata = struct([]);
        sharedParameters = struct([]);
end

end

