function rainSTORM_exportTracker(pointillisticData, rawData_fullFilename, supResFigHandle, cameraSignalConversion)
% 	Summary:	
%	Version:	0.3 - table version
%               0.2 - enable multiple exports from a reconstruction
%               0.1 - initial
%	Note:		http://devopsreactions.tumblr.com/post/75139222312/looking-at-someone-elses-code
%	Package:	rainSTORM v3.1+    (based on Box Tracker and Bridge Tracker and Histograms)
%	Developer:	gajdost
%	Name:		Gajdos Tams
%	Company:	University of Szeged

% FUNCTION
%   Selects localizations within a user-defined box
%   Exports to workspace
%
% USER NOTES
% 0. This tool identifies localizations within a user-defined rectangle.
% 1. Apply this tool to the most recent super-res reconstruction Figure
%    It searches for reviewed Posits - i.e. accepted Localisations -
%    which are only retained for one Figure at a time
%    To avoid confusion, I recommend closing all figure windows, and then
%    plotting a Reviewed reconstruction to work on with this tool - EJR.
% 2. The tool allow you to select one rectangular region within the
%    Super-resolution reconstruction.
% 3. All localisations within this region are identified, and stored as
%    bridgedPosits and associated bridgedParams
% 4. Based on the box tracker code.
%% Part 0: Flow Control and Input Arguments

% Speed things up

answer = inputdlg({'Number'},'Areas to export',[1 20],{'1'});
for i = 1:str2num(answer{1})

    %%Identify user-boxed localisations
    ROI=pointillisticData_selectROI.drawUprightRectangle(supResFigHandle);
    cutPointillisticData = pointillisticData_selectROI.filterROI(pointillisticData, ROI, cameraSignalConversion);
    reviewedPosits = [cutPointillisticData.x_coord, cutPointillisticData.y_coord];
    
    unitString_output = 'camera pixel length';
    [convertedROIParameters, ~]=unitConversion.convertROI(ROI.parameters, unitString_output, cameraSignalConversion);

    center_x = convertedROIParameters.center.x;
    center_y = convertedROIParameters.center.y;

    ROI_bounds_x = center_x + [-convertedROIParameters.size.x,convertedROIParameters.size.x]/2;
    ROI_bounds_y = center_y + [-convertedROIParameters.size.y,convertedROIParameters.size.y]/2;

    positions_nm=reviewedPosits*cameraSignalConversion.pixelSize_nm;

    %% Export
    if istable(cutPointillisticData)
        export.SectionParams = table2struct(cutPointillisticData);
    else
        export.SectionParams = cutPointillisticData;
    end
    export.SectionPosits = positions_nm;
    export.SectionInfo = [ROI_bounds_x; ROI_bounds_y];
    export.SectionRawDataFullFilename = rawData_fullFilename;
    export.export_name = ['X',num2str(round(center_x)),'Y',num2str(round(center_y))];
    assignin('base',export.export_name,export);
    %% Export to csv
    outPutFullFileName=[rawData_fullFilename,'_export','_X',num2str(round(center_x)),'_Y',num2str(round(center_y)),'.mat'];
    % rainSTORM_save_csv(cutPointillisticData,outPutFullFileName, 3); % Ugly, ugly hack.
    % Just tell the user about the export.
    [~, outPutFileName, outPutExt]=fileparts(outPutFullFileName);
    disp(['Exported to: ', outPutFileName, outPutExt])
    % And also, just in case, export to mat
    save(outPutFullFileName, 'export');
end

end
