function [localizationData, metadata, sharedParameters] = rainSTORM_precision(localizationData, method, settings)

if pointillisticData_fieldNameManagement.isMemberField(localizationData, 'sig')
    isAstigmatic = false;
elseif pointillisticData_fieldNameManagement.isMemberField(localizationData, {'sig_x', 'sig_y'})
    isAstigmatic = true;
else
    error('The localization data given for localization precision calculation does not contain the neccessary "Gaussian sigma" fields.')
end

switch method
    case 'center of mass'
        % for simple centroid estimation
        % it does not accounts for the background noise
        if ~isAstigmatic
            std = localizationPrecisionEstimation.centroid(localizationData.sig, localizationData.sum_signal, settings.countsPerElectron);
            localizationData.std = std;
        else
            std_x = localizationPrecisionEstimation.centroid(localizationData.sig_x, localizationData.sum_signal, settings.countsPerElectron);
            std_y = localizationPrecisionEstimation.centroid(localizationData.sig_y, localizationData.sum_signal, settings.countsPerElectron);
            localizationData.std_x = std_x;
            localizationData.std_y = std_y;
        end
    case 'Thompson'
        % weigted least-squares without EM excess noise
        % the legacy rainSOTRM's default despite the rainSTORM's
        % localization algorithm it not weighted least squares and it does
        % not account for the excess EM noise...
        if ~isAstigmatic
            std = localizationPrecisionEstimation.Thompson(localizationData.sig, localizationData.sum_signal, localizationData.backgroundSTD, settings.countsPerElectron);
            localizationData.std = std;
        else
            std_x = localizationPrecisionEstimation.Thompson(localizationData.sig_x, localizationData.sum_signal, localizationData.backgroundSTD, settings.countsPerElectron);
            std_y = localizationPrecisionEstimation.Thompson(localizationData.sig_y, localizationData.sum_signal, localizationData.backgroundSTD, settings.countsPerElectron);
            localizationData.std_x = std_x;
            localizationData.std_y = std_y;
        end
    case 'Mortensen, Gaussian mask estimation'
        % unweighted least squares with EM excess noise
        if ~isAstigmatic
            std = localizationPrecisionEstimation.Mortensen_GME(localizationData.sig, localizationData.sum_signal, localizationData.backgroundSTD, settings.countsPerElectron);
            localizationData.std = std;
        else
            std_x = localizationPrecisionEstimation.Mortensen_GME(localizationData.sig_x, localizationData.sum_signal, localizationData.backgroundSTD, settings.countsPerElectron);
            std_y = localizationPrecisionEstimation.Mortensen_GME(localizationData.sig_y, localizationData.sum_signal, localizationData.backgroundSTD, settings.countsPerElectron);
            localizationData.std_x = std_x;
            localizationData.std_y = std_y;
        end
    case 'DeSantis'
        % weigted least-squares with EM excess noise
        % use it for astigmatic data
        if ~isAstigmatic
            std = localizationPrecisionEstimation.DeSantis(localizationData.sig, localizationData.sig, localizationData.sum_signal, localizationData.backgroundSTD, settings.countsPerElectron);
            localizationData.std = std;
        else
            [std_x, std_y] = localizationPrecisionEstimation.DeSantis(localizationData.sig_x, localizationData.sig_y, localizationData.sum_signal, localizationData.backgroundSTD, settings.countsPerElectron);
            localizationData.std_x = std_x;
            localizationData.std_y = std_y;
        end
    otherwise
        error('Unknown method "%s" for rainSTORM''s precision calculation.', method);
end

metadata = struct([]);
sharedParameters = struct([]);

end

