function rainSTORM_bridgeTracker(pointillisticData, supResFigHandle, cameraSignalConversion)
% 	Summary:	Artifact scope for evaluating fits.
%	Version:	0.8
%	Note:		http://devopsreactions.tumblr.com/post/75139222312/looking-at-someone-elses-code
%	Package:	rainSTORM v4.0+    (based on Box Tracker)
%	Developer:	gajdost
%	Name:		Gajdos Tams and Novk Tibor
%	Company:	University of Szeged

% FUNCTION
%   Selects quality-controlled localizations within a user-defined box
%   Plots the data as a scatterplot, colour coded by sigma_x/sigma_y
%   May be used to inspect data for bridge artifact
%
% USER NOTES
% 0. This tool identifies localizations within a user-defined rectangle.
% 1. Apply this tool to the most recent super-res reconstruction Figure
%    It searches for reviewed Posits - i.e. accepted Localisations -
%    which are only retained for one Figure at a time
%    To avoid confusion, I recommend closing all figure windows, and then
%    plotting a Reviewed reconstruction to work on with this tool - EJR.
% 2. The tool allow you to select one rectangular region within the
%    Super-resolution reconstruction.
% 3. All localisations within this region are identified, and stored as
%    bridgedPosits and associated bridgedParams
% 4. Based on the box tracker code.
%% Part 0: Flow Control and Input Arguments

ROI=pointillisticData_selectROI.drawUprightRectangle(supResFigHandle);
close(supResFigHandle);
cutPointillisticData = pointillisticData_selectROI.filterROI(pointillisticData, ROI, cameraSignalConversion);

y_coord = cutPointillisticData.y_coord;
x_coord = cutPointillisticData.x_coord;

sum_signal = cutPointillisticData.sum_signal / cameraSignalConversion.countsPerElectron;

if pointillisticData_fieldNameManagement.isMemberField(cutPointillisticData, 'std_x')
    std = cutPointillisticData.std_x * cameraSignalConversion.pixelSize_nm;
else
    std = cutPointillisticData.std * cameraSignalConversion.pixelSize_nm;
end

if pointillisticData_fieldNameManagement.isMemberField(cutPointillisticData, 'sig_x')
    sig = cutPointillisticData.sig_x;
else
    sig = cutPointillisticData.sig;
end

if pointillisticData_fieldNameManagement.isMemberField(cutPointillisticData, 'res')
    fit_error = cutPointillisticData.res;
elseif pointillisticData_fieldNameManagement.isMemberField(cutPointillisticData, 'res')
    fit_error = cutPointillisticData.chi2;
else
    fit_error = [];
    warning('The localization data does not contain fit error field (res, chi2). Cannot visualize the fit error.')
end



%% Display
% Note that Y-positions are plotted as negative row positions,
% to match image matrix orientation.
figure('Name','Artifact Scope','NumberTitle','off');

%% Fit error subplot
if ~isempty(fit_error)
    subplot(2,2,1);
    scatter(y_coord, -x_coord, 12, fit_error, 'x')
    set(gca,'FontName','Times New Roman','Fontsize',10)
    title('Fit error', 'fontSize', 10, 'fontWeight', 'bold');
    colorbar;
    % colormap(jet);
    set(gca, 'fontSize', 10, 'fontWeight', 'bold');
    axis equal % Set axis increments to be of equal size; prevent stretching
end

%% Sum_signal subplot
subplot(2,2,2);
scatter(y_coord, -x_coord, 12, sum_signal, 'x')
set(gca,'FontName','Times New Roman','Fontsize',10)
title('Sum Signal [camera count]', 'fontSize', 10, 'fontWeight', 'bold');
colorbar;
% colormap(jet);
set(gca, 'fontSize', 10, 'fontWeight', 'bold');
axis equal % Set axis increments to be of equal size; prevent stretching

%% X precision supblot
subplot(2,2,3);
scatter(y_coord, -x_coord, 12, std, 'x')
set(gca,'FontName','Times New Roman','Fontsize',10)
title('Precision X [nm]', 'fontSize', 10, 'fontWeight', 'bold');
colorbar;
caxis([5,25]);
set(gca, 'fontSize', 10, 'fontWeight', 'bold');
axis equal % Set axis increments to be of equal size; prevent stretching

%% Sigma_X subplot
subplot(2,2,4);
scatter(y_coord, -x_coord, 12, sig, 'x')
set(gca,'FontName','Times New Roman','Fontsize',10)
title('Gaussian RMS X [nm]', 'fontSize', 10, 'fontWeight', 'bold');
colorbar;
% colormap(jet);
caxis([0.7, 1.5])
set(gca, 'fontSize', 10, 'fontWeight', 'bold');
axis equal % Set axis increments to be of equal size; prevent stretching
