function [figureObject, colormapVector, metadata, sharedParameters] = rainSTORM_display(imageMatrix, pixelCenters, method, settings)


%text_figure_name = settings.figureName;
text_figure_name = method;
cameraSignalConversion = settings.cameraSignalConversion;

% creating the figure window:
figureObject = figure(...
    'Name',text_figure_name,...
    'NumberTitle','off',...
    'Visible', 'off');

if ~settings.colorbarFlag
    % creatinf the image without scalebar
    
    imshow(imageMatrix, 'border', 'tight', 'XData', pixelCenters.y(1,:), 'YData', pixelCenters.x(:,1));
    set(imhandles(figureObject), 'UserData', struct('unit', pixelCenters.unit))
    
    % remark, could not recreate the "'border', 'tight'" setting in a meaningful way, partial soplution only (the figure window size is not adjusted):
%     axis tight;
%     set(gca,'position',[0 0 1 1],'units','normalized')
else
    % creating the image with scalebar
    
    imshow(imageMatrix, 'XData', pixelCenters.y, 'YData', pixelCenters.x);
    set(imhandles(figureObject), 'UserData', struct('unit', pixelCenters.unit))
    
    colorbar;
    axis on;
    %axis square;
    
    set(gca,'XTick',[])
    set(gca,'YTick',[])
end

colormapRange = [0, 0];
switch method
    case 'fixed contrast'
        colormapRange = settings.colormapContrastRange;
    case 'percentile saturation'
        pixelValues = imageMatrix(:);
        colormap_maxValue = prctile(pixelValues, 100-settings.saturatedPercentage);
        colormapRange = [0, ceil(colormap_maxValue)];
    case 'percentile of non-zeros saturation'
        pixelValues = imageMatrix(:);
        pixelValues(pixelValues==0) = [];
        colormap_maxValue = prctile(pixelValues, 100-settings.saturatedPercentage);
        colormapRange = [0, ceil(colormap_maxValue)];
    otherwise
end

% get a custom defiend or Matlab's built-in colormap:
[colormapVector, colormapRange] = customColormap.getColormap(settings.colormapName, colormapRange(1), colormapRange(2));
colormap(figureObject, colormapVector)

% or use Matlab-'s built-in colormaps
%colormap(settings.colormapName)
% get Matlab's colormap
%colormapVector = colormap(settings.colormapName);

% setting the colormap range:
axesHandle=imgca(figureObject);
set(axesHandle, 'CLim', double(colormapRange));
% Matlab is really a big pile of bugs. I have to use the line above for the
% color map range setting to make it work reliably. When using the line
% below, sometimes it sets the colormap, sometimes it doesn't....
%caxis(colormapRange);

hold on

if(settings.scalebarFlag) % Length for a 1 micron scalebar
    scalebar_length = unitConversion.convertValue(1, 'um', pixelCenters.unit, cameraSignalConversion);
    
  plot([max(xlim) (max(xlim)...
      -scalebar_length)], ...
        [max(ylim)*0.9 max(ylim)*0.9],...
        'LineStyle', '-', 'Color', settings.scalebarColor,'LineWidth',3);
end

hold off

metadata = struct([]);
sharedParameters.supResImageColormapRange = colormapRange;

end
