function rainSTORM_histogramTracker(pointillisticData, supResFigHandle, cameraSignalConversion)
% 	Summary:	
%	Version:	0.4
%	Note:		http://devopsreactions.tumblr.com/post/75139222312/looking-at-someone-elses-code
%	Package:	rainSTORM v4.0+    (based on Box Tracker and Bridge Tracker and Histograms)
%	Developer:	Gajdos Tams, Novk Tibor
%	Company:	University of Szeged

% FUNCTION
%   Selects localizations within a user-defined box
%   Creates "the histogram" from the area
%
% USER NOTES
% 0. This tool identifies localizations within a user-defined rectangle.
% 1. Apply this tool to the most recent super-res reconstruction Figure
%    It searches for reviewed Posits - i.e. accepted Localisations -
%    which are only retained for one Figure at a time
%    To avoid confusion, I recommend closing all figure windows, and then
%    plotting a Reviewed reconstruction to work on with this tool - EJR.
% 2. The tool allow you to select one rectangular region within the
%    Super-resolution reconstruction.
% 3. All localisations within this region are identified, and stored as
%    bridgedPosits and associated bridgedParams
% 4. Based on the box tracker code.
%% Part 0: Flow Control and Input Arguments

ROI=pointillisticData_selectROI.drawUprightRectangle(supResFigHandle);
close(supResFigHandle);
cutPointillisticData = pointillisticData_selectROI.filterROI(pointillisticData, ROI, cameraSignalConversion);

if ~pointillisticData_fieldNameManagement.isMemberField(pointillisticData, 'I')
    if pointillisticData_fieldNameManagement.isMemberField(pointillisticData, 'sig')
        pointillisticData.I = pointillisticData.sum_signal./(2*pi*pointillisticData.sig.^2);
    elseif pointillisticData_fieldNameManagement.isMemberField(pointillisticData, 'sig_x') && pointillisticData_fieldNameManagement.isMemberField(pointillisticData, 'sig_y')
        pointillisticData.I = pointillisticData.sum_signal./(2*pi*pointillisticData.sig_x.*pointillisticData.sig_y);
    else
        pointillisticData.I = pointillisticData.sum_signal;
        warning('The \"sum_signal\" is used in the Histogram Tracker instead of the \"I\" parameter (Gaussian peak height).')
    end
end

brightness = pointillisticData.sum_signal / cameraSignalConversion.countsPerElectron;

reviewedPosits = [cutPointillisticData.x_coord, cutPointillisticData.y_coord];

frame_index_max = cutPointillisticData.frame_idx(end);

%meanPerFrame = varfun(@mean, struct2table(bridgedParams), 'GroupingVariables', 'frame_idx');
%sumPerFrame = varfun(@sum, struct2table(bridgedParams), 'GroupingVariables', 'frame_idx');

PerFrame.frame_idx = 1:frame_index_max;
PerFrame.groupCount = zeros(frame_index_max, 1);
PerFrame.mean_I = zeros(frame_index_max, 1);
PerFrame.sum_I = zeros(frame_index_max, 1);
for i= 1:frame_index_max
    actualFrameBoolean = pointillisticData.frame_idx == i;
    PerFrame.groupCount(i) = sum(actualFrameBoolean);
    PerFrame.mean_I(i) = mean(pointillisticData.I(actualFrameBoolean));
    PerFrame.sum_I(i) = sum(pointillisticData.I(actualFrameBoolean));
end


%% Display
% Note that Y-positions are plotted as negative row positions,
% to match image matrix orientation.

% Plot graphs
figSize = [1,100,1120,840];
figure(...
    'Name','Histogram Tracking',...
    'NumberTitle','off',...
    'OuterPosition', figSize ...
    );

%% First Subplot:
subplot(2,3,1) % Use this if screen shape spoils the method below

bar_factor = 0.6;

[myNGood, bin_edges] = histcounts(brightness, 'BinLimits',[min(brightness),max(brightness)]); % Get Hist data
bin_centers = (bin_edges(1:end-1)+ bin_edges(2:end))/2;

hold on
bar(bin_centers,myNGood,'r','stacked', 'BarWidth', bar_factor);
hold off
set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
title('Sum Signal');
xlabel('Photoelectrons')
ylabel('Number of Candidates');

%% Second sublot -trimmed box tracking
subplot(2,3,2)

myCmap = colormap( jet(frame_index_max) ); % 1 entry per frame
boxedColour = ones(size(cutPointillisticData.frame_idx,1), 3);
for lpBox = 1:size(reviewedPosits,1)
    boxedColour(lpBox,:) = myCmap(cutPointillisticData.frame_idx(lpBox), : );
end
scatter(reviewedPosits(:,2), -reviewedPosits(:,1), 12, boxedColour, 'x')
set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
title('Box Tracking');
xlabel('y [camera pixel]');
ylabel('x [camera pixel]');
caxis([0 size(myCmap,1) ])
axis equal % Set axis increments to be of equal size; prevent stretching

%% Third subplot
subplot(2,3,3)

plot(PerFrame.frame_idx, PerFrame.groupCount);
set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
title('Localizations/frame');
ylabel('Localization Count');
xlabel('Frame Index');

%% Old Third subplot
% %plot(meanPerFrame.frame_idx, meanPerFrame.mean_sig_x, meanPerFrame.frame_idx, meanPerFrame.mean_sig_y, meanPerFrame.frame_idx, meanPerFrame.mean_x_std/10, meanPerFrame.frame_idx, meanPerFrame.mean_y_std/10);
% plot(meanPerFrame.frame_idx, meanPerFrame.mean_sig_x, meanPerFrame.frame_idx, meanPerFrame.mean_x_std/10);
% hold on
% title('Averages per Frame');
% ylabel({'Sigma [px]'; 'Thompson-Precision/10 [nm]'},'FontSize',10);
% %legend('Sigma X','Sigma Y','STD X','STD Y','Location','southoutside','Orientation','horizontal');
% legend('Sigma_X','STD_X/10','Location','southoutside','Orientation','horizontal');
% %xlim([100 300]);
% ylim([0 4]);
% hold off

%% Fourth supblot
subplot(2,3,4)

if pointillisticData_fieldNameManagement.isMemberField(cutPointillisticData, 'sig_x') && pointillisticData_fieldNameManagement.isMemberField(cutPointillisticData, 'sig_y')
    sig_x_vals = double(cutPointillisticData.sig_x);
    sig_y_vals = double(cutPointillisticData.sig_y);
else
    sig_x_vals = double(cutPointillisticData.sig);
    sig_y_vals = double(cutPointillisticData.sig);
end

sig_x_vals_nm = sig_x_vals * cameraSignalConversion.pixelSize_nm;
sig_y_vals_nm = sig_y_vals * cameraSignalConversion.pixelSize_nm;

bar_factor = 0.4;
sig_min = 0.5 * cameraSignalConversion.pixelSize_nm;
sig_max = 3.0 * cameraSignalConversion.pixelSize_nm;
sig_step = 0.1 * cameraSignalConversion.pixelSize_nm;
[count_row_good, bin_edges] = histcounts(sig_x_vals_nm,'BinLimits',[sig_min,sig_max],'BinWidth',sig_step); % Get Hist data
count_col_good = histcounts(sig_y_vals_nm,'BinLimits',[sig_min,sig_max],'BinWidth',sig_step); % Get Hist data
bin_centers = (bin_edges(1:end-1)+ bin_edges(2:end))/2;

hold on
h_row = bar(bin_centers-bar_factor*sig_step/2,count_row_good,'r','stacked', 'BarWidth', bar_factor);
h_col = bar(bin_centers+bar_factor*sig_step/2,count_col_good,'b','stacked', 'BarWidth', bar_factor);
% set(h_row(2),'FaceColor',[0.4 0.4 0.4]);
% set(h_col(2),'FaceColor',[0.4 0.4 0.4]);
hold off
set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
xlim([sig_min-bar_factor*sig_step sig_max+bar_factor*sig_step]);
title('Gaussian RMS widths');
xlabel('Width [nm]');
ylabel('Number of Candidates');
if ~sum(count_row_good)==0 && ~sum(count_col_good)==0     % If there are red and blue bars
  legend([h_row(1) h_col(1)],'Row','Col'); % Then give a legend for them
end


%% Fifth subplot
subplot(2,3,5);

if pointillisticData_fieldNameManagement.isMemberField(cutPointillisticData, 'std_x') && pointillisticData_fieldNameManagement.isMemberField(cutPointillisticData, 'std_y')
    x_std_local = double(cutPointillisticData.std_x);
    y_std_local = double(cutPointillisticData.std_y);
else
    x_std_local = double(cutPointillisticData.std);
    y_std_local = double(cutPointillisticData.std);
end

x_std_local_nm = x_std_local * cameraSignalConversion.pixelSize_nm;
y_std_local_nm = y_std_local * cameraSignalConversion.pixelSize_nm;

std_min = 0;
std_max = 50;
std_step = 2;

[count_row_good,bin_edges] = histcounts(x_std_local_nm,'BinLimits',[std_min,std_max],'BinWidth',std_step); % Inter-Row direction
count_col_good = histcounts(y_std_local_nm,'BinLimits',[std_min,std_max],'BinWidth',std_step); % Inter-Column direction
bin_centers = (bin_edges(1:end-1)+ bin_edges(2:end))/2;

hold on
h_row = bar(bin_centers-bar_factor*std_step/2,count_row_good,'r','stacked', 'BarWidth', 0.4);
h_col = bar(bin_centers+bar_factor*std_step/2,count_col_good,'b','stacked', 'BarWidth', 0.4);
% set(h_row(2),'FaceColor',[0.4 0.4 0.4]);
% set(h_col(2),'FaceColor',[0.4 0.4 0.4]);
hold off
set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
xlim([0 50])    % Set x-range to the interesting 0-150 nm region
title('Localisation Precisions (nm)');
xlabel('Precision [nm]');
ylabel('Number of Candidates');
if ~sum(count_row_good)==0 && ~sum(count_col_good)==0     % If there are red and blue bars
  legend([h_row(1) h_col(1)],'Row','Col'); % Then give a legend for them
end

%% Sixth subplot
subplot(2,3,6);
hold on
%plot(PerFrame.frame_idx, PerFrame.sum_I, PerFrame.frame_idx, PerFrame.mean_I);
%ylabel('I_{Mean} & I_{Sum}','FontSize',10);
%ylim([0 max(PerFrame.sum_I)]);
plot(PerFrame.frame_idx, PerFrame.mean_I);
set(gca, 'FontSize', 12, 'FontWeight', 'bold', 'FontName', 'Times');
title('Fitted peak heights');
ylabel('I_{Mean} [camera count]');
ylim([0 max(PerFrame.mean_I)]);
xlabel('Frame Index');
hold off