function [figureObject] = rainStorm_astigmatic3D_calibrationVisualization(calibrationData)


z_nm = calibrationData.z_nm;
loc_N = calibrationData.loc_N;
sig_x_mean_nm = calibrationData.sig_x_mean_nm;
sig_y_mean_nm = calibrationData.sig_y_mean_nm;
sig_x_std_nm = calibrationData.sig_x_std_nm;
sig_y_std_nm  =calibrationData.sig_y_std_nm;

%%
% plotting figures to determine the appropriate range for fitting

% plotting the mean values of the PSF widths belonging to each frame
figureObject = figure();
figureObject.Position(3:4) = [840 560];
subplot(2,1,1);
errorbar(z_nm, sig_x_mean_nm, sig_x_std_nm, "s", "MarkerSize",10,"MarkerEdgeColor","blue","MarkerFaceColor",[0.65, 0.85, 0.90]);
%scatter(zPosFrame, sigMeanFrameX,10, 'b','.');
hold on
errorbar(z_nm, sig_y_mean_nm, sig_y_std_nm, "s", "MarkerSize",10,"MarkerEdgeColor","red","MarkerFaceColor",[255, 114, 118]/255);
%scatter(zPosFrame, sigMeanFrameY,10, 'r','.');
hold off
xLimits = xlim;
ticks = xLimits(1):200:xLimits(2);
set(gca, 'xtick', ticks);
grid on
title('Fitted Gaussian widths');
ylabel('Sigma [px]');
xlabel('Z position [nm]');

if numel(varargin) == 1
xline(varargin{1}(1))
xline(varargin{1}(2))
end



% plotting the number of localizations belonging to each frame
subplot(2,1,2);
plot(zPos_frame, loc_N)
xLimits = xlim;
ticks = xLimits(1):200:xLimits(2);
set(gca, 'xtick', ticks);
grid on
title('Localization number');
ylabel('Number');
xlabel('Z position [nm]');

if numel(varargin) == 1
xline(varargin{1}(1))
xline(varargin{1}(2))
end

end

