function varargout = rainSTORM_Offset_Calibration_Tool(varargin)
% RAINSTORM_OFFSET_CALIBRATION_TOOL MATLAB code for rainSTORM_Offset_Calibration_Tool.fig
%      RAINSTORM_OFFSET_CALIBRATION_TOOL, by itself, creates a new RAINSTORM_OFFSET_CALIBRATION_TOOL or raises the existing
%      singleton*.
%
%      H = RAINSTORM_OFFSET_CALIBRATION_TOOL returns the handle to a new RAINSTORM_OFFSET_CALIBRATION_TOOL or the handle to
%      the existing singleton*.
%
%      RAINSTORM_OFFSET_CALIBRATION_TOOL('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RAINSTORM_OFFSET_CALIBRATION_TOOL.M with the given input arguments.
%
%      RAINSTORM_OFFSET_CALIBRATION_TOOL('Property','Value',...) creates a new RAINSTORM_OFFSET_CALIBRATION_TOOL or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before rainSTORM_Offset_Calibration_Tool_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to rainSTORM_Offset_Calibration_Tool_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help rainSTORM_Offset_Calibration_Tool

% Last Modified by GUIDE v2.5 18-Jan-2025 11:31:58

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @rainSTORM_Offset_Calibration_Tool_OpeningFcn, ...
                   'gui_OutputFcn',  @rainSTORM_Offset_Calibration_Tool_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);

if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end               
% End initialization code - DO NOT EDIT


% --- Executes just before rainSTORM_Offset_Calibration_Tool is made visible.
function rainSTORM_Offset_Calibration_Tool_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to rainSTORM_Offset_Calibration_Tool (see VARARGIN)

% Choose default command line output for rainSTORM_Offset_Calibration_Tool
handles.output = hObject;

%GUI_path = fileparts(fullfile(mfilename('fullpath')));
GUI_path = '../GUI';
last_image_dir_filename = fullfile(GUI_path, 'last_image_dir.txt');
if exist(last_image_dir_filename, 'file')
    handles.last_image_dir = fileread(last_image_dir_filename);
else
    handles.last_image_dir = pwd;
end

[dataFileFullNameList]=pointillisticData_selection.multiple(handles.last_image_dir);

if isempty(dataFileFullNameList)
   return 
end

handles.pointillisticDatas = {};
for idxFile = 1:numel(dataFileFullNameList)

    % TODO: handle other data convention
    convention = 'rainSTORM';
    
    pointillisticDataObject = pointillisticDataClass();
    
    pointillisticDataObject.dataImport(dataFileFullNameList{idxFile}, convention)
    
    handles.pointillisticDatas{end+1} = pointillisticDataObject;
end

handles.Channel_names = arrayfun(...
    @(x)handles.pointillisticDatas{x,1}.dataName,...
    1:numel(handles.pointillisticDatas),...
    'UniformOutput',0)';
set(handles.popupmenu_Select_Reference_Channel,'String',handles.Channel_names);

handles.optoff = repmat(struct(...
    'Name',' ',...
    'Ch1_Pairs',[],...
    'Ch2_Pairs',[],...
    'matchRadius',1.25,...
    'Nmarkers',50,...
    'TFORM',[]...
    ),length(handles.Channel_names)-1,1);

handles = setup_Optical_Offset_Settings_Panel(hObject, eventdata, handles);

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes rainSTORM_Offset_Calibration_Tool wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = rainSTORM_Offset_Calibration_Tool_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes on selection change in popupmenu_Select_Reference_Channel.
function popupmenu_Select_Reference_Channel_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_Select_Reference_Channel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu_Select_Reference_Channel contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_Select_Reference_Channel
handles = setup_Optical_Offset_Settings_Panel(hObject, eventdata, handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function popupmenu_Select_Reference_Channel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_Select_Reference_Channel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in pushbutton_Eval_Offsets.
function pushbutton_Eval_Offsets_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Eval_Offsets (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selected_reference = get(handles.popupmenu_Select_Reference_Channel,'Value');
Ch1_SupResParams = handles.pointillisticDatas{selected_reference}.accepted;

num_of_optoff = length(handles.optoff);
for idx_optoff = 1:num_of_optoff
    if idx_optoff < selected_reference
        idx_ch_to_correct = idx_optoff;
    else
        idx_ch_to_correct = idx_optoff+1;
    end
    Ch2_SupResParams = handles.pointillisticDatas{idx_ch_to_correct}.accepted;
    handles.optoff(idx_optoff) = rainSTORM_offsetFind(handles.optoff(idx_optoff),Ch1_SupResParams,Ch2_SupResParams);
end

guidata(hObject, handles);

% --- Executes on button press in pushbutton_Show_Results.
function pushbutton_Show_Results_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Show_Results (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% % % num_of_optoff = length(handles.optoff);
% % % for idx_optoff = 1:num_of_optoff
% % %     offPairsCH1=handles.optoff(idx_optoff).Ch1_Pairs;
% % %     offPairsCH2=handles.optoff(idx_optoff).Ch2_Pairs;
% % %     if ~isempty(offPairsCH1) && ~isempty(offPairsCH2)
% % %         figure('Name',['Localization pairs used in calibration: ',handles.optoff(idx_optoff).Name],'NumberTitle','off')
% % %         scatter(offPairsCH1(:,2), -offPairsCH1(:,1), '+r');
% % %         hold on
% % %         scatter(offPairsCH2(:,2), -offPairsCH2(:,1), '+g');
% % %         hold off
% % %         set(gca,'FontSize', 12, 'FontWeight', 'bold')
% % %         title('Optical Offset Markers')
% % %         xlabel('CCD pixel, column-direction (horizontal)');
% % %         ylabel(' - CCD pixel, row-direction (vertical)');
% % %     end
% % % end

rainSTORM_evaluate_optoff_calibration(handles.optoff);


% --- Executes on button press in pushbutton_Save.
function pushbutton_Save_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Save (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

calibration_tool_def_dir = fileparts(fullfile(mfilename('fullpath')));
[FileName,PathName] = uiputfile(...
    {'*.mat'},...
    'Select file to Save Optical Offset Correction Data',...
    calibration_tool_def_dir);

if ~isequal(FileName, 0) && ~isequal(PathName, 0)
    filename = fullfile(PathName,FileName);
    optoff = handles.optoff;
    save(filename, 'optoff');
end

% --- Executes during object creation, after setting all properties.
function slider_Optical_Offset_Settings_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider_Optical_Offset_Settings (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end
set(hObject,'Visible','off')

function handles = setup_Optical_Offset_Settings_Panel(hObject, eventdata, handles)

h = get(handles.uipanel_Optical_Offset_Settings,'Children');
h(h == handles.slider_Optical_Offset_Settings) = [];
h(h == handles.text_num_of_Markers) = [];
h(h == handles.text_Match_Radius) = [];
delete(h);
handles.Optical_Offset_Settings_h = [];

selected_reference = get(handles.popupmenu_Select_Reference_Channel,'Value');

X = handles.Channel_names;
X(selected_reference) = [];
X = arrayfun(@(x)([X{x},' to ',handles.Channel_names{selected_reference}]),1:length(X),'UniformOutput',0)';
[handles.optoff.Name] = deal(X{:});

panel_pos = get(handles.uipanel_Optical_Offset_Settings,'Position');
panel_unit = get(handles.uipanel_Optical_Offset_Settings,'Unit');

panel_line_space = 30;
panel_first_line_pos = panel_pos(4)-30;
panel_max_lines = floor(panel_first_line_pos / panel_line_space);

optoff_settings = struct(...
    'name',{'Nmarkers';'matchRadius'},...
    'type',{'number';'number'},...
    'x_pos',{220;300});

num_of_optoff = length(handles.optoff);
num_of_params = length(optoff_settings);

for idx_optoff = 1:num_of_optoff
    if idx_optoff > panel_max_lines
        visibility='off';
    else
        visibility='on';
    end
    % descriptions
    handles.Optical_Offset_Settings_h(idx_optoff).h(1) = uicontrol(...
        handles.uipanel_Optical_Offset_Settings,...
        'Style','text',...
        'String',handles.optoff(idx_optoff).Name,...
        'HorizontalAlignment','left',...
        'BackgroundColor',[0.8 0.8 0.8],...
        'Units',panel_unit,...
        'Visible',visibility,...
        'Position', [10 panel_first_line_pos-idx_optoff*panel_line_space 150 20]);
    % input uicontrols
    for idx_param = 1:num_of_params
        handles.Optical_Offset_Settings_h(idx_optoff).h(1+idx_param) = uicontrol(...
            handles.uipanel_Optical_Offset_Settings,...
            'Callback',{@set_Optical_Offset_Settings_value, idx_optoff, optoff_settings(idx_param).name, optoff_settings(idx_param).type},...
            'Style','edit',...
            'String',num2str(handles.optoff(idx_optoff).(optoff_settings(idx_param).name)),...
            'HorizontalAlignment','center',...
            'Units',panel_unit,...
            'Visible',visibility,...
            'Position', [optoff_settings(idx_param).x_pos  panel_first_line_pos-idx_optoff*panel_line_space 70 20]);
    end
end

if num_of_optoff<=panel_max_lines
    set(handles.slider_Optical_Offset_Settings,...
        'Visible','off');
else
    set(handles.slider_Optical_Offset_Settings,...
        'Visible','on',...
        'Min',0,'Max',(num_of_optoff-panel_max_lines),...
        'Value',(num_of_optoff-panel_max_lines),...
        'Callback',{@uipanel_Optical_Offset_Settings_slider_callback,...
        handles, panel_first_line_pos, panel_max_lines, panel_line_space},...
        'SliderStep',[1 1]./(num_of_optoff-panel_max_lines));
end
guidata(hObject, handles);

function uipanel_Optical_Offset_Settings_slider_callback(hObject, eventdata, handles, panel_first_line_pos, panel_max_lines, panel_line_space)

val = get(hObject,'Value');

num_of_params = length(handles.Optical_Offset_Settings_h);
for idx_setting = 1:num_of_params
    for idx_component = 1:length(handles.Optical_Offset_Settings_h(idx_setting).h)
        h = handles.Optical_Offset_Settings_h(idx_setting).h(idx_component);
        pos = get(h,'Position');
        pos_new = panel_first_line_pos - idx_setting * panel_line_space + (num_of_params-panel_max_lines - val) * panel_line_space;
        pos(2) = pos_new;
        if (pos_new < panel_first_line_pos - panel_max_lines * panel_line_space) || (pos_new > panel_first_line_pos - panel_line_space)
            visibility='off';
        else
            visibility='on';
        end
        set(h,...
            'Position',pos,...
            'Visible',visibility);
    end
end
guidata(hObject, handles);

function set_Optical_Offset_Settings_value(hObject, eventdata, idx_optoff, param_name, type)

handles = guidata(gcbo);
switch type
    case 'number'
        data_to_write = str2num(get(hObject,'String'));
    case 'text'
        data_to_write = get(hObject,'String');
    otherwise
        data_to_write = get(hObject,'String');
end
handles.optoff(idx_optoff).(param_name) = data_to_write;
guidata(hObject, handles);
