function rainSTORM_evaluate_optoff_calibration(optoff)

[X, Y] = meshgrid(0:25:512,0:25:512);
ref = [X(:), Y(:)];

[X2, Y2] = meshgrid(0:50:512,0:50:512);
ref2 = [X2(:), Y2(:)];

for idx_optoff = 1:length(optoff)
    
    text_figure_name = optoff(idx_optoff).Name;
    figSize = [1,100,1120,840];
    figHandle = figure(...
        'Name',text_figure_name,...
        'NumberTitle','off',...
        'OuterPosition', figSize ...
        );
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Optical offset
    subplot(2,2,1)
    tr_coord = tforminv(optoff(idx_optoff).TFORM,ref(:,1),ref(:,2));
    dist = sqrt(sum((tr_coord-ref).^2,2));
    Z = reshape(dist,size(X));
    surf(X,Y,Z)
    axis tight
    set(gca, 'FontSize', 12, 'FontWeight', 'Bold', 'FontName', 'Times');
    title('Optical Offset')
    xlabel('X coord')
    ylabel('Y coord')
    colorbar
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % quiver plot
    subplot(2,2,2)
    tr_coord2 = tforminv(optoff(idx_optoff).TFORM,ref2(:,1),ref2(:,2));
    diff_vec = (tr_coord2-ref2);
    X2_dif = reshape(diff_vec(:,1),size(X2));
    Y2_dif = reshape(diff_vec(:,2),size(X2));
    quiver(X2,Y2,X2_dif,Y2_dif)
    axis tight
    set(gca, 'FontSize', 12, 'FontWeight', 'Bold', 'FontName', 'Times');
    title('quiver plot')
    xlabel('X coord')
    ylabel('Y coord')
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % scatter plot of marker positions
    subplot(2,2,3)
    offPairsCH1=optoff(idx_optoff).Ch1_Pairs;
    offPairsCH2=optoff(idx_optoff).Ch2_Pairs;
    if ~isempty(offPairsCH1) && ~isempty(offPairsCH2)
        scatter(offPairsCH1(:,2), -offPairsCH1(:,1), '+r');
        hold on
        scatter(offPairsCH2(:,2), -offPairsCH2(:,1), '+g');
        hold off
        set(gca, 'FontSize', 12, 'FontWeight', 'Bold', 'FontName', 'Times');
        title('Optical Offset Markers')
        xlabel('CCD pixel, column-direction (horizontal)');
        ylabel(' - CCD pixel, row-direction (vertical)');
    end
end


