function optoff = rainSTORM_offsetFind(optoff,Ch1_SupResParams,Ch2_SupResParams)
% Copyright 2012. Refer to 00_license.txt for details.
%   Reads localisation data from 2 channels
%   Channel 1 is RED   fluorescence, for example
%   Channel 2 is GREEN fluorescence, for example
%   ( 'optoff' is a prefix for OPTical OFFset values, by the way)
%   Heuristically identifies matching pairs of white markers in each image
%   Using these localisations as control points
%   Identifies the transform to correct channel 2 back onto channel 1
%   Returns output data to the base workspace
%   Control Point Transforms need the MATLAB image processing kit, I think
%   _DeltaX and _Params are not used, but are loaded for future convenience

% Flow Control and arbitrary numbers
matchRadius = optoff.matchRadius; % Markers correspond if within this radius, CCD pixels
Nmarkers = optoff.Nmarkers;

% Arbitrarily choose the first non empty frame of each channel data, if
% multiple frames were captured.
frameCH1 = min(Ch1_SupResParams.frame_idx);
frameCH2 = min(Ch2_SupResParams.frame_idx);

% Keep rows of localisation data from the chosen frame for each channel
Ch1_SupResParams = Ch1_SupResParams(Ch1_SupResParams.frame_idx==frameCH1);
Ch1_reviewedPosits = [Ch1_SupResParams.x_coord Ch1_SupResParams.y_coord];

Ch2_SupResParams = Ch2_SupResParams([Ch2_SupResParams.frame_idx]==frameCH2);
Ch2_reviewedPosits = [Ch2_SupResParams.x_coord Ch2_SupResParams.y_coord];

% 2. Check the number of markers in both channels.
Nmarkers = min([...
    size(Ch1_reviewedPosits,1) ...
    size(Ch2_reviewedPosits,1) ...
    Nmarkers
    ]);

offPairsCH1 = -ones(Nmarkers,2); % Delete unsolved -1s at end
offPairsCH2 = -ones(Nmarkers,2);

for lpPairs = 1:Nmarkers
    thisPositCH1 = Ch1_reviewedPosits(lpPairs,:);
    vectCH2f1 = Ch2_reviewedPosits - repmat(thisPositCH1,size(Ch2_reviewedPosits,1),1);
    distCH2f1 = sqrt(vectCH2f1(:,1).^2 + vectCH2f1(:,2).^2);
    
    possPositsCH2 = Ch2_reviewedPosits(distCH2f1 < matchRadius,:);
    if(size(possPositsCH2,1)==1)
        offPairsCH1(lpPairs,:) = thisPositCH1;
        offPairsCH2(lpPairs,:) = possPositsCH2;
    end
end

% This loop should have found corresponding RED and GREEN marker positions
% Now expunge -1 values, which signify unsolved pairs
offPairsCH1( (offPairsCH1(:,1) == -1),:) = []; % Delete unfound values
offPairsCH2( (offPairsCH2(:,1) == -1),:) = [];

% Now determine the transform from CH2 back to CH1, using control points
% In MATLAB cp2tform, input is the image that needs to be warped to bring
% it into the coordinate system of the base image
% 19/09/2012 - this order works provided tforminv() is used for correction:

% TFORM = cp2tform(offPairsCH1,offPairsCH2,'polynomial',2);
TFORM = cp2tform(offPairsCH1,offPairsCH2,'nonreflective similarity');

% (input_points, base_points, ...
% Note, need 10 noncolinear pairs for cubic, 6 pairs for quadratic
optoff.Ch1_Pairs = offPairsCH1;
optoff.Ch2_Pairs = offPairsCH2;
optoff.matchRadius = matchRadius;% write back to store the actually used value
optoff.Nmarkers = Nmarkers;% write back to store the actually used value
optoff.TFORM = TFORM;

end

