function [algorithmFields, analysesFields] = rainSTORM_dataConversionDefinitions()
% This function has no real practical purpose, it is defines only for
% consistency reasons. Its defines conversion of the data from the default format
% (rainSTORM) to the rainSTORM data format, which is also the default. So
% it keeps the data as is.



%TODO:
% trajectory
% polarization stuff

commonFields = [...
    struct(...
        'fieldname', 'frame_idx',...
        'header', 'frame_idx',...
        'unit', 'camera frame interval',...
        'description','fame index',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'frame_idx')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.frame_idx...
        ),...
    struct(...
        'fieldname', 'x_coord',...
        'header', 'x_coord',...
        'unit', 'camera pixel length',...
        'description','x coordinate',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'x_coord')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.x_coord...
        ),...
    struct(...
        'fieldname', 'y_coord',...
        'header', 'y_coord',...
        'unit', 'camera pixel length',...
        'description','y coordinate',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'y_coord')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.y_coord...
        ),...
    struct(...
        'fieldname', 'background',...
        'header', 'background',...
        'unit', 'camera count',...
        'description','background',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'background')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.background...
        ),...
    struct(...
        'fieldname', 'backgroundSTD',...
        'header', 'backgroundSTD',...
        'unit', 'camera count',...
        'description','fluorescent background noise',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'backgroundSTD')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.backgroundSTD...
        ),...
    struct(...
        'fieldname', 'sum_signal',...
        'header', 'sum_signal',...
        'unit', 'camera count',...
        'description','sum signal of the PSF',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'sum_signal')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.sum_signal...
        ),...
 ];

fit_error = [...
    struct(...
        'fieldname', 'res',...
        'header', 'res',...
        'unit', '',...
        'description','measure of the error of the fit',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'res')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.res...
        )...    
];

nonAstigmaticFields = [...
    struct(...
        'fieldname', 'sig',...
        'header', 'sig',...
        'unit', 'camera pixel length',...
        'description','fitted width',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'sig')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.sig...
        ),...
        ];


astigmaticFields = [...
    struct(...
        'fieldname', 'sig_x',...
        'header', 'sig_x',...
        'unit', 'camera pixel length',...
        'description','fitted width along the X axis',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'sig_x')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.sig_x...
        ),...
    struct(...
        'fieldname', 'sig_y',...
        'header', 'sig_y',...
        'unit', 'camera pixel length',...
        'description','fitted width along the Y axis',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'sig_y')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.sig_y...
        )...
    ];


algorithmFields = [...
    struct(...
        'name', 'LS Multi Gaussian 2D linear Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            nonAstigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Multi Astigmatic Gaussian 2D linear Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            astigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Multi Gaussian 2D const Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            nonAstigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Gaussian 2D linear Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            nonAstigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Astigmatic Gaussian 2D linear Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            astigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Gaussian 2D const Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            nonAstigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Astigmatic Gaussian 2D const Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            astigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Gaussian Halt3',...
        'fields',[...
            commonFields,...
            fit_error,...
            nonAstigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Gaussian Thorough',...
        'fields',[...
            commonFields,...
            fit_error,...
            nonAstigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'Centre of Mass',...
        'fields',[...
            commonFields,...
            nonAstigmaticFields...
            ]...
    ),...
    ];



analysesFields = [...
    struct(...
        'name', 'precision',...
        'fields',[...
            struct(...
                'fieldname', 'std',...
                'header', 'std',...
                'unit', 'camera pixel length',...
                'description','localization precision',...
                'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'std')),...
                'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.std...
                ),...
            ]...
    ),...
    struct(...
        'name', 'astigmatic precision',...
        'fields',[...
            struct(...
                'fieldname', 'std_x',...
                'header', 'std_x',...
                'unit', 'camera pixel length',...
                'description','localization precision along the X axis',...
                'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'std_x')),...
                'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.std_x...
                ),...
            struct(...
                'fieldname', 'std_y',...
                'header', 'std_y',...
                'unit', 'camera pixel length',...
                'description','localization precision along the Y axis',...
                'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'std_y')),...
                'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.std_y...
                )...
            ]...
    ),...
    struct(...
        'name', 'astigmatic 3D',...
        'fields',[...
            struct(...
                'fieldname', 'z_coord',...
                'header', 'z_coord',...
                'unit', 'camera pixel length',...
                'description','axial coordinate of the localization',...
                'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'z_coord')),...
                'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.z_coord...
                )...
            ]...
    ),...
    ];


end
