function rainSTORM_data_fields = rainSTORM_dataDefinitions()
% Stores the field definitions (names, units and description of the data
% fields,) of rainSTORM. The is handled in this format internally.
% The data fields must be unique.


rainSTORM_data_fields = struct(...
    'frame_idx', struct(...
        'unit', 'camera frame interval',...
        'description','fame index'...
        ),...
    'x_coord', struct(...
        'unit', 'camera pixel length',...
        'description','x coordinate'...
        ),...
    'y_coord', struct(...
        'unit', 'camera pixel length',...
        'description','y coordinate'...
        ),...
    'background', struct(...
        'unit', 'camera count',...
        'description','background'...
        ),...
    'backgroundSTD', struct(...
        'unit', 'camera count',...
        'description','fluorescent background noise'...
        ),...
    'sum_signal', struct(...
        'unit', 'camera count',...
        'description','sum signal of the PSF'...
        ),...
    'res', struct(...
        'unit', '',...
        'description','measure of the error of the fit'...
        ),...
    'sig', struct(...
        'unit', 'camera pixel length',...
        'description','fitted widths'...
        ),...
     'sig_x', struct(...
        'unit', 'camera pixel length',...
        'description','fitted width along the X axis'...
        ),...
    'sig_y', struct(...
        'unit', 'camera pixel length',...
        'description','fitted width along the Y axis'...
        ),...
    'std', struct(...
        'unit', 'camera pixel length',...
        'description','localization precision'...
        ),...
    'std_x', struct(...
        'unit', 'camera pixel length',...
        'description','localization precision along the X axis'...
        ),...
    'std_y', struct(...
        'unit', 'camera pixel length',...
        'description','localization precision along the Y axis'...
        ),...
    'z_coord', struct(...
        'unit', 'camera pixel length',...
        'description','axial coordinate of the localization'...
        )...
 );

end