function [pointillisticData, analysisParameters] = rainSTORM_dataImport(dataFileFullName, definedCameraSignalConversion)

% Beware!!! it can only import the 'Recon 1' info, it is not handled correctly even in the original rainSTORM...

[dataPath, dataName, extension] = fileparts(dataFileFullName);
infoFileFullName = strrep(dataFileFullName, extension, '_info.json');

analysisParameters = pointillisticData_load.infoStruct(infoFileFullName);

% overwrite the parametrs that could not be read out from the
% metadata with the default ones:
loadedCameraSignalConversion = analysisParameters.sharedParameters.cameraSignalConversion;
missingOnlyBoolean = true;
overwrittenCameraSignalConversion = imageStack_getConversionFactors.overwriteParameters(loadedCameraSignalConversion, definedCameraSignalConversion, missingOnlyBoolean);
analysisParameters.sharedParameters.cameraSignalConversion = overwrittenCameraSignalConversion;

% if the analyses field was empty (cell) befre exportig, the sml does not
% retain it, so it needs to be added here....
if ~isfield(analysisParameters.sharedParameters.convention, 'analyses')
    analysisParameters.sharedParameters.convention.analyses = {};
end

analysisParameters.sharedParameters.originalDataPath = dataPath;
analysisParameters.sharedParameters.originalDataName = dataName;

pointillisticData = pointillisticData_load.tabularData(dataFileFullName);

end

