function [algorithmFields, analysesFields] = rainSTORM_legacy_dataConversionDefinitions()

% localizationAlgorithmFields, calculatedFields, analysisFields
% localizationAlgorithm ''
% calculations {}
% analyses {}

% algorithm '' info saved with creation operations
% calculations??? info not saved with "operations"
% analyses {} info saved with processing operations


%TODO:
% trajectory
% polarization stuff

commonFields = [...
    struct(...
        'fieldname', 'frame_idx',...
        'header', 'frame_idx',...
        'unit', 'camera frame interval',...
        'description','fame index',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'frame_idx')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.frame_idx...
        ),...
    struct(...
        'fieldname', 'x_coord',...
        'header', 'x_coord',...
        'unit', 'camera pixel length',...
        'description','x coordinate',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'x_coord')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.x_coord...
        ),...
    struct(...
        'fieldname', 'y_coord',...
        'header', 'y_coord',...
        'unit', 'camera pixel length',...
        'description','y coordinate',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'y_coord')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.y_coord...
        ),...
    struct(...
        'fieldname', 'background',...
        'header', 'roi_min',...
        'unit', 'camera count',...
        'description','fluorescent background',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'roi_min')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.background...
        ),...
    struct(...
        'fieldname', 'backgroundSTD',...
        'header', 'avg_brightness',...
        'unit', 'camera count',...
        'description','fluorescent background noise',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'avg_brightness')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.backgroundSTD...
        ),...
    struct(...
        'fieldname', 'sum_signal',...
        'header', 'Sum_signal',...
        'unit', 'camera count',...
        'description','sum signal of the PSF',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'Sum_signal')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.sum_signal...
        ),...
 ];

fit_error = [...
    struct(...
        'fieldname', 'res',...
        'header', 'res',...
        'unit', '',...
        'description','measure of the error of the fit',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'res')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.res...
        )...    
];

nonAstigmaticFields = [...
    struct(...
        'fieldname', '',...
        'header', 'I',...
        'unit', 'camera count',...
        'description','PSF height',...
        'function_forward', '',...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.sum_signal./(2*pi*pointillisticData.sig.^2)...
        ),...
    struct(...
        'fieldname', 'sig',...
        'header', 'sig_x',...
        'unit', 'camera pixel length',...
        'description','fitted width',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'sig_x')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.sig...
        ),...
    struct(...
        'fieldname', '',...
        'header', 'sig_y',...
        'unit', 'camera pixel length',...
        'description','fitted width',...
        'function_forward', '',...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.sig...
        )...
        ];


astigmaticFields = [...
    struct(...
        'fieldname', '',...
        'header', 'I',...
        'unit', 'camera count',...
        'description','intensity',...
        'function_forward', '',...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.sum_signal./(2*pi*pointillisticData.sig_x.*pointillisticData.sig_y)...
        ),...
    struct(...
        'fieldname', 'sig_x',...
        'header', 'sig_x',...
        'unit', 'camera pixel length',...
        'description','fitted width',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'sig_x')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.sig_x...
        ),...
    struct(...
        'fieldname', 'sig_y',...
        'header', 'sig_y',...
        'unit', 'camera pixel length',...
        'description','fitted width',...
        'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'sig_y')),...
        'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.sig_y...
        )...
    ];


algorithmFields = [...
    struct(...
        'name', 'LS Multi Gaussian 2D linear Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            nonAstigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Multi Astigmatic Gaussian 2D linear Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            astigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Multi Gaussian 2D const Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            nonAstigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Gaussian 2D linear Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            nonAstigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Astigmatic Gaussian 2D linear Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            astigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Gaussian 2D const Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            nonAstigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Astigmatic Gaussian 2D const Bg',...
        'fields',[...
            commonFields,...
            fit_error,...
            astigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Gaussian Halt3',...
        'fields',[...
            commonFields,...
            fit_error,...
            nonAstigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'LS Gaussian Thorough',...
        'fields',[...
            commonFields,...
            fit_error,...
            nonAstigmaticFields...
            ]...
    ),...
    struct(...
        'name', 'Centre of Mass',...
        'fields',[...
            commonFields,...
            nonAstigmaticFields...
            ]...
    ),...
    ];

% fuck everyone and everything, really
% the naming convention changed sometime in the legacy rainstorm
% in Matlab one cannot initialize a structure with a cell array element....
algorithmFields(1).name = {'LS Multi Gaussian 2D linear Bg', 'Least-Squares Multi Gaussian 2D linear Bg'};
algorithmFields(2).name = {'LS Multi Astigmatic Gaussian 2D linear Bg', 'Least-Squares Multi Astigmatic Gaussian 2D linear Bg'};
algorithmFields(3).name = {'LS Multi Gaussian 2D const Bg', 'Least-Squares Multi Gaussian 2D const Bg'};
algorithmFields(4).name = {'LS Gaussian 2D linear Bg', 'Least-Squares Gaussian 2D linear Bg'};
algorithmFields(5).name = {'LS Astigmatic Gaussian 2D linear Bg', 'Least-Squares Astigmatic Gaussian 2D linear Bg'};
algorithmFields(6).name = {'LS Gaussian 2D const Bg', 'Least-Squares Gaussian 2D const Bg'};
algorithmFields(7).name = {'LS Astigmatic Gaussian 2D const Bg', 'Least-Squares Astigmatic Gaussian 2D const Bg'};
algorithmFields(8).name = {'LS Gaussian Halt3', 'Least-Squares Gaussian Halt3'};
algorithmFields(9).name = {'LS Gaussian Thorough', 'Least-Squares Gaussian Thorough'};


analysesFields = [...
    struct(...
        'name', 'precision',...
        'fields',[...
            struct(...
                'fieldname', 'std',...
                'header', 'x_std',...
                'unit', 'nm',...
                'description','localization precision',...
                'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'x_std'))/cameraSignalConversion.pixelSize_nm,...
                'function_backward',@(pointillisticData, cameraSignalConversion) rainSTORM_precision_mod(pointillisticData.sig, pointillisticData.sum_signal, pointillisticData.background, 'Thompson', cameraSignalConversion.countsPerPhoton)*cameraSignalConversion.pixelSize_nm...
                ),...
            struct(...
                'fieldname', '',...
                'header', 'y_std',...
                'unit', 'nm',...
                'description','localization precision',...
                'function_forward', '',...
                'function_backward',@(pointillisticData, cameraSignalConversion) rainSTORM_precision_mod(pointillisticData.sig, pointillisticData.sum_signal, pointillisticData.background, 'Thompson', cameraSignalConversion.countsPerPhoton)*cameraSignalConversion.pixelSize_nm...
                )...
            ]...
    ),...
    struct(...
        'name', 'astigmatic precision',...
        'fields',[...
            struct(...
                'fieldname', 'std_x',...
                'header', 'x_std',...
                'unit', 'nm',...
                'description','localization precision along the X axis',...
                'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'x_std'))/cameraSignalConversion.pixelSize_nm,...
                'function_backward',@(pointillisticData, cameraSignalConversion) rainSTORM_precision_mod(pointillisticData.sig_x, pointillisticData.sum_signal, pointillisticData.backgroundSTD, 'Thompson', cameraSignalConversion.countsPerPhoton)...
                ),...
            struct(...
                'fieldname', 'std_y',...
                'header', 'y_std',...
                'unit', 'nm',...
                'description','localization precision along the Y axis',...
                'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'y_std'))/cameraSignalConversion.pixelSize_nm,...
                'function_backward',@(pointillisticData, cameraSignalConversion) rainSTORM_precision_mod(pointillisticData.sig_y, pointillisticData.sum_signal, pointillisticData.backgroundSTD, 'Thompson', cameraSignalConversion.countsPerPhoton)...
                )...
            ]...
    ),...
    struct(...
        'name', 'ellipticity',...
        'fields',[...
            struct(...
                'fieldname', '',...
                'header', 'ellipticity',...
                'unit', '',...
                'description','ellipticity of the astigmatic PSF',...
                'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) 0,...
                'function_backward', @(pointillisticData, cameraSignalConversion) rainSTORM_ellipticity_multi( 'symmetrical', pointillisticData.sig_x, pointillisticData.sig_y)...
                )...
            ]...
    ),...
    struct(...
        'name', 'astigmatic 3D',...
        'fields',[...
            struct(...
                'fieldname', 'z_coord',...
                'header', 'z_coord',...
                'unit', 'camera pixel length',...
                'description','axial coordinate of the localization',...
                'function_forward', @(dataMatrix, dataHeaders, cameraSignalConversion) dataMatrix(:, strcmp(dataHeaders, 'z_coord')),...
                'function_backward', @(pointillisticData, cameraSignalConversion) pointillisticData.z_coord...
                )...
            ]...
    ),...
    ];


end
