function rainSTORM_legacy_dataExport(directoryPath, originalDataName, pointillisticData, analysisParameters, varargin)


    [~, name, ~] = fileparts(originalDataName);
    
    recon_name = 'Recon 1';
    infoFileName = [name, '_', recon_name, '-info.txt'];
    
    infoStructFileName = [name, '_info.xml'];
    
    dataFileName = [name, '_', 'reviewedSupResParams.full.csv'];
    
    localizationOperation = findOperation.creation(analysisParameters, 'localizationData', 'localization');
    if isempty(localizationOperation)
        error('There is no localization operation saved in the analysis parameters. Either perform it, or save the localization data without saving tha analysis parameters.')
    end
    
    algorithm = localizationOperation.sharedParametrs.algorithm;
    analyses = localizationOperation.sharedParametrs.analyses;
   

    infoText = rainSTORM_infoFile(analysisParameters, pointillisticData, varargin{:});

    convention = 'rainSTORM legacy';
    cameraSignalConversion = analysisParameters.sharedParameters.cameraSignalConversion;
    [dataMatrix, dataHeaders] = convertDataToExport(pointillisticData, convention, algorithm, analyses, cameraSignalConversion);
    
    pointillisticData_save.headerAndMatrixData(directoryPath, dataFileName, dataHeaders, dataMatrix)
    
    pointillisticData_save.infoStruct(directoryPath, infoStructFileName, analysisParameters);
    
    pointillisticData_save.infoText(directoryPath, infoFileName, infoText)
    
end



function infoText = rainSTORM_infoFile(analysisParameters, pointillisticData_accepted, varargin)

    infoText = '';

    originalDataFullName  = fullfile(analysisParameters.sharedParameters.originalDataPath, analysisParameters.sharedParameters.originalDataName);
    stackSize = analysisParameters.sharedParameters.stackSize;
    
    fieldNames = pointillisticData_fieldNameManagement.getFieldNames(pointillisticData_accepted);
    
    cameraSignalConversion = analysisParameters.sharedParameters.cameraSignalConversion;
    
    imageStackReadingOperation = findOperation.creation(analysisParameters, 'imageStack', 'reading');
    
    localizationOperation = findOperation.creation(analysisParameters, 'localizationData', 'localization');
    
    localizationFilteringOperation = findOperation.processing(analysisParameters, 'localizationData', 'filtering');
    
    localizationDriftCorrectionOperation = findOperation.processing(analysisParameters, 'localizationData', 'driftCorrection');
    
    localizationVisualizationOperation = findOperation.processing(analysisParameters, 'localizationData', 'visualization');
    supResPixelSize_nm = [];
    linearMagnification = [];
    colormapRange = [];
    imageType = '';
    if ~ isempty(localizationVisualizationOperation)
        supResPixelSize_original = localizationVisualizationOperation.settings.pixelization.pixelSize;
        supResPixelSizeVect_nm = unitConversion.convert2DVectorQuantity(supResPixelSize_original, 'nm', cameraSignalConversion);
        % lets choose the "x" pixel size:
        supResPixelSize_nm  = supResPixelSizeVect_nm.x;

        linearMagnification = cameraSignalConversion.pixelSize_nm/supResPixelSize_nm;
        % TODO: colormapRangeTODO
        colormapRange = localizationVisualizationOperation.settings.visualization.colormapRange;
        imageType = localizationVisualizationOperation.settings.imageType;
    end
    
    originalMetadata = struct([]);
    if numel(varargin)> 1
        originalMetadata = varargin{1};
    end
    
    infoText = [infoText, sprintf('#Information about Reconstructed Image: created with the "new" rainnSTORm#\n\n' )];
    infoText = [infoText, sprintf('Raw Image Data: %s \n', originalDataFullName)];
    % the only parameter required for compatibility with the "legacy"
    % rainSTORM is the "frame size":
    infoText = [infoText, sprintf('sizeOfCCDFrame: [%d %d]\n', ...
            stackSize(1), ...
            stackSize(2))];
    infoText = [infoText, sprintf('Recon Name: %s \n', 'Recon 1')];
    infoText = [infoText, sprintf('Date: %s \n\n', datestr(now, 'dd-mmm-yyyy  HH.MM.SS') )];
    
    if sum(strcmp(fieldNames, 'std_x'))==1 || sum(strcmp(fieldNames, 'std_y'))==1
        reviewedDeltaX = [pointillisticData_accepted.std_x, pointillisticData_accepted.std_y];
    elseif sum(strcmp(fieldNames, 'std'))==1
        reviewedDeltaX = [pointillisticData_accepted.std, pointillisticData_accepted.std];
    end
    meanRevDeltaX = mean(reviewedDeltaX); % Mean precision in reconstruction
    stdRevDeltaX  = std(reviewedDeltaX);  % Std Dev of precisions- poor metric?
    SparrowThompsonLimit = 2*sqrt(mean(reviewedDeltaX.^2)); % Approx. 'resolution'
    
    infoText = [infoText, sprintf('Precision Limit= 2*RMS precision (nm) ROW-axis: %f \n', ...
        SparrowThompsonLimit(1))];
    infoText = [infoText, sprintf('Precision Limit= 2*RMS precision (nm) COL-axis: %f \n', ...
        SparrowThompsonLimit(2))];
    infoText = [infoText, sprintf('Sparse Sampling Limit= 3*RMS precision (nm) ROW-axis: %f \n', ...
        1.5 * SparrowThompsonLimit(1))];
    infoText = [infoText, sprintf('Sparse Sampling Limit= 3*RMS precision (nm) COL-axis: %f \n', ...
        1.5 * SparrowThompsonLimit(2))];
    infoText = [infoText, sprintf('Mean precision estimate (row-direction nm): %f \n', ...
        meanRevDeltaX(1))];
    infoText = [infoText, sprintf('Mean precision estimate (col-direction nm): %f \n', ...
        meanRevDeltaX(2))];
    infoText = [infoText, sprintf('StDv precision estimate (row-direction nm): %f \n', ...
        stdRevDeltaX(1))];
    infoText = [infoText, sprintf('StDv precision estimate (col-direction nm): %f \n', ...
        stdRevDeltaX(2))];
    
    infoText = [infoText, sprintf('CCD pixel width on sample (nm): %i \n', ...
        cameraSignalConversion.pixelSize_nm)];
    if ~ isempty(supResPixelSize_nm)
        infoText = [infoText, sprintf('Super-resolution image pixel width (nm): %i \n', ...
            supResPixelSize_nm)];
    end
    infoText = [infoText, sprintf('Counts per photon for calibration: %f \n', ...
        cameraSignalConversion.countsPerPhoton)];
    infoText = [infoText, sprintf('Number of accepted localisations: %i \n', ...
        localizationFilteringOperation.metadata.acceptedNumber)];
    infoText = [infoText, sprintf('Number of rejected candidates: %i \n', ...
        localizationFilteringOperation.metadata.rejectedNumber)];
    
    % Generate the info about the localization settings.
    infoText = [infoText, sprintf('\n# Localization Settings: \n' )];
    locAlgoName = localizationOperation.function;
     locSettings = localizationOperation.settings;
     if ~isempty(locAlgoName)
        infoText = [infoText, sprintf('Localization Algorithm: %s \n', ...
            locAlgoName)];
     end
     if ~isempty(locSettings)
        infoText = [infoText, sprintf('%s: %s \n', ...
            'Image filter algorithm:', ...
            locSettings.ImageFilter)];
        infoText = [infoText, sprintf('%s: %i \n', ...
            'ROI Candidate Threshold:',...
            locSettings.Thresh)];
        infoText = [infoText, sprintf('%s: %i \n', ...
            'ROI Candidate Relative Peak Value Threshold:',...
            locSettings.Thresh2)];
        infoText = [infoText, sprintf('%s: [%d %d]\n', ...
            'Allowed Sigma [pix]:',...
            locSettings.allowSig(1),...
            locSettings.allowSig(2))];
        infoText = [infoText, sprintf('%s: %i \n', ...
            'Allowed  Distance [pix]:',...
            locSettings.allowX)];
        infoText = [infoText, sprintf('%s: %d \n', ...
            'Initial guess of PSF Sigma [pix]:',...
            locSettings.initSig)];
        infoText = [infoText, sprintf('%s: %i \n', ...
            'Maximum Iterations:',...
            locSettings.maxIts)];
        infoText = [infoText, sprintf('%s: %i \n', ...
            'Preview Scale Factor [int]:',...
            locSettings.prevSF)];
        infoText = [infoText, sprintf('%s: %i \n', ...
            'Radius of ROI [pix]:',...
            locSettings.rad)];
        infoText = [infoText, sprintf('%s: %d \n', ...
            'Tolerance [-]:',...
            locSettings.tol)];
        infoText = [infoText, sprintf('Precision Algorithm: %s \n', ...
            'dummy text')];
        infoText = [infoText, sprintf('Ellipticity Algorithm: %s \n', ...
            'dummy text')];
        infoText = [infoText, sprintf('Modality: %s \n', ...
            'dummy text')];
     end
           
    % Generate the info about the reconstruction settings.
    infoText = [infoText, sprintf('\n# Reconstruction Extended Settings: \n' )];
    
    if ~ isempty(localizationVisualizationOperation)
        infoText = [infoText, sprintf('Reconstruction Algorithm: %s \n', ...
            imageType)];
    end
    if ~isempty(linearMagnification)
        infoText = [infoText, sprintf('%s: %i \n', ...
            'Reconstruction Scale Factor:',...
            linearMagnification)];
    end
    if ~ isempty(colormapRange)
        infoText = [infoText, sprintf('Contrast Windowing: [%i %i] \n', ...
            colormapRange(1),...
            colormapRange(2))];
    end

    % Generate the info about the used filter data.
    infoText = [infoText, sprintf('\n# Filter Data: \n' )];
    
    if ~isempty(localizationFilteringOperation)
        %filteringThresholdsMat = localizationFilteringOperation.settings.thresholds;
        %filteringConvention = localizationFilteringOperation.settings.convention;

        filteringThresholds = [];
%         if ~strcmp(filteringConvention, 'rainSTORM')
%             [thresholds_rainSTORM, thresholdNames] = convertData(filteringThresholds, fitting_method, measured_quantity, evaluations, definitionFunction, cameraSignalConversion);
%         end
        thresholdNames = {};

        if sum(strcmp(thresholdNames, 'frame_idx'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'frame_idx'));
            infoText = [infoText, sprintf('%s: %s \n', 'Frame Index', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Frame Index', 'NaN NaN')];
        end
        if sum(strcmp(thresholdNames, 'x_coord'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'x_coord'));
            infoText = [infoText, sprintf('%s: %s \n', 'X coordinate', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'X coordinate', 'NaN NaN')];
        end
        if sum(strcmp(thresholdNames, 'y_coord'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'y_coord'));
            infoText = [infoText, sprintf('%s: %s \n', 'Y coordinate', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Y coordinate', 'NaN NaN')];
        end
        if sum(strcmp(thresholdNames, 'z_coord'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'z_coord'));
            infoText = [infoText, sprintf('%s: %s \n', 'Z coordinate', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Z coordinate', 'NaN NaN')];
        end
        if sum(strcmp(thresholdNames, 'std_x'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'std_x'));
            infoText = [infoText, sprintf('%s: %s \n', 'Thompson Std X', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Thompson Std X', num2str('NaN NaN','% g'))];
        end
        if sum(strcmp(thresholdNames, 'std_y'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'std_y'));
            infoText = [infoText, sprintf('%s: %s \n', 'Thompson Std Y', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Thompson Std Y', num2str('NaN NaN','% g'))];
        end
        if sum(strcmp(thresholdNames, 'I'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'I'));
            infoText = [infoText, sprintf('%s: %s \n', 'I parameter', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'I parameter', num2str('NaN NaN','% g'))];
        end
        if sum(strcmp(thresholdNames, 'sig_x'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'sig_x'));
            infoText = [infoText, sprintf('%s: %s \n', 'Sigma X', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Sigma X', num2str('NaN NaN','% g'))];
        end
        if sum(strcmp(thresholdNames, 'sig_y'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'sig_y'));
            infoText = [infoText, sprintf('%s: %s \n', 'Sigma Y', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Sigma Y', num2str('NaN NaN','% g'))];
        end
        if sum(strcmp(thresholdNames, 'ellip_xy'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'ellip_xy'));
            infoText = [infoText, sprintf('%s: %s \n', 'Ellipticity Sig_XY', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Ellipticity Sig_XY', 'NaN NaN')];
        end
        if sum(strcmp(thresholdNames, 'avg_brightness'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'avg_brightness'));
            infoText = [infoText, sprintf('%s: %s \n', 'Average Brightness', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Average Brightness', 'NaN NaN')];
        end
        if sum(strcmp(thresholdNames, 'res'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'res'));
            infoText = [infoText, sprintf('%s: %s \n', 'Residue', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Residue', 'NaN NaN')];
        end
        if sum(strcmp(thresholdNames, 'res_Row'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'res_Row'));
            infoText = [infoText, sprintf('%s: %s \n', 'Residue Row', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Residue Row', 'NaN NaN')];
        end
        if sum(strcmp(thresholdNames, 'res_Col'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'res_Col'));
            infoText = [infoText, sprintf('%s: %s \n', 'Residue Col', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Residue Col', 'NaN NaN')];
        end
        if sum(strcmp(thresholdNames, 'roi_min'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'roi_min'));
            infoText = [infoText, sprintf('%s: %s \n', 'ROI Min', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'ROI Min', 'NaN NaN')];
        end
        if sum(strcmp(thresholdNames, 'Sum_signal'))==1
            threshold = thresholds_rainSTORM(:, strcmp(thresholdNames, 'Sum_signal'));
            infoText = [infoText, sprintf('%s: %s \n', 'Sum Signal', num2str(threshold,'% g'))];
        else
            infoText = [infoText, sprintf('%s: %s \n', 'Sum Signal', 'NaN NaN')];
        end
    end

    if ~isempty(localizationDriftCorrectionOperation)
        totalDrift = unitConversion.convert2DVectorQuantity(localizationDriftCorrectionOperation.metadata.totalDrift, 'camera pixel length', cameraSignalConversion);
        if isfield(ch_data.reviewer{selected_recon,1}.settings,'auto_undrift')
            infoText = [infoText, sprintf('\n# Drift Correction: \n' )];
            infoText = [infoText, sprintf('Total Drift: [%f %f]\n', ...
                totalDrift.dx, ...
                totalDrift.dy)];
        end
    end
    
    % TODO: other metadata
    if ~isempty(originalMetadata)
    % Check if the nd2 metadata report was enabled, and we actually used the nd2 readmethod
        infoText = [infoText, sprintf('\n# ND2 data from BioFormats: \n' )];
        infoText = [infoText, sprintf('m_VersionString: %s \n', ...
            originalMetadata.get('Global m_VersionString'))];
        infoText = [infoText, sprintf('Camera Name: %s \n', ...
            originalMetadata.get('Global Camera Name'))];
        infoText = [infoText, sprintf('Conversion Gain #1: %s \n', ...
            originalMetadata.get('Global Conversion Gain #1'))];
        infoText = [infoText, sprintf('Exposure: %s \n', ...
            originalMetadata.get('Global Exposure'))];
        infoText = [infoText, sprintf('GainMultiplier: %s \n', ...
            originalMetadata.get('Global GainMultiplier'))];
        infoText = [infoText, sprintf('Readout Speed: %s \n', ...
            originalMetadata.get('Global Readout Speed #1'))];
        infoText = [infoText, sprintf('Readout Mode #1: %s \n', ...
            originalMetadata.get('Global Readout Mode #1'))];
        infoText = [infoText, sprintf('Readout Rate #1: %s \n', ...
            originalMetadata.get('Global Readout Rate #1'))];
        infoText = [infoText, sprintf('Sensor Mode #1: %s \n', ...
            originalMetadata.get('Global Sensor Mode #1'))];
        infoText = [infoText, sprintf('dExposureTime: %f \n', ...
            originalMetadata.get('Global dExposureTime'))];
        infoText = [infoText, sprintf('sObjective: %s \n', ...
            originalMetadata.get('Global sObjective'))];
        infoText = [infoText, sprintf('m_dZoomPosition: %f \n', ...
            originalMetadata.get('Global m_dZoomPosition'))];
        infoText = [infoText, sprintf('Cube Name: %s \n', ...
            originalMetadata.get('Global Name'))];
        infoText = [infoText, sprintf('dAcqTime: %f \n', ...
            originalMetadata.get('Global dAcqTime'))];
        infoText = [infoText, sprintf('dAvgPeriodDiff: %f \n', ...
            originalMetadata.get('Global dAvgPeriodDiff'))];
        infoText = [infoText, sprintf('dBinningX: %s \n', ...
            originalMetadata.get('Global dBinningX'))];
        infoText = [infoText, sprintf('dBinningY: %s \n', ...
            originalMetadata.get('Global dBinningY'))];
        infoText = [infoText, sprintf('dCalibration: %f \n', ...
            originalMetadata.get('Global dCalibration'))];
        infoText = [infoText, sprintf('Bottom: %s \n', ...
            originalMetadata.get('Global Bottom'))];
        infoText = [infoText, sprintf('Top: %s \n', ...
            originalMetadata.get('Global Top'))];
        infoText = [infoText, sprintf('Left: %s \n', ...
            originalMetadata.get('Global Left'))];
        infoText = [infoText, sprintf('Right: %s \n', ...
            originalMetadata.get('Global Right'))];
        infoText = [infoText, sprintf('dXPos: %f \n', ...
            originalMetadata.get('Global dXPos'))];
        infoText = [infoText, sprintf('dYPos: %f \n', ...
            originalMetadata.get('Global dYPos'))];
        infoText = [infoText, sprintf('dZPos: %f \n', ...
            originalMetadata.get('Global dZPos'))];
    else
        infoText = [infoText, sprintf('\n# ND2 data from BioFormats: \n' )];
        infoText = [infoText, sprintf('Exposure: %s \n', ...
            cameraSignalConversion.exposureTime_ms )];
        infoText = [infoText, sprintf('dExposureTime: %f \n', ...
            cameraSignalConversion.exposureTime_ms)];
        
        cameraSettings = struct([]);
        if ~isempty(imageStackReadingOperation)
            if isfield(imageStackReadingOperation, 'metadata')
                if isfield(imageStackReadingOperation.metadata, 'cameraSettings')
                    cameraSettings = imageStackReadingOperation.metadata.cameraSettings;
                end
            end
        end
        if ~isempty(cameraSettings)
            infoText = [infoText, sprintf('Camera Name: %s \n', ...
                [cameraSettings.manufacturer, ' ', cameraSettings.model, ' ', cameraSettings.serialNumber])];
            infoText = [infoText, sprintf('Conversion Gain #1: %s \n', ...
                [num2str(cameraSettings.settings.conversionGain), 'x'])];
            infoText = [infoText, sprintf('GainMultiplier: %s \n', ...
                num2str(cameraSettings.settings.amplificationGain))];
            infoText = [infoText, sprintf('Readout Speed: %s \n', ...
                cameraSettings.settings.readOutRate)];
            infoText = [infoText, sprintf('Readout Mode #1: %s \n', ...
                '')];
            infoText = [infoText, sprintf('Readout Rate #1: %s \n', ...
                '')];
            infoText = [infoText, sprintf('Sensor Mode #1: %s \n', ...
                '')];
        end
        
    end
    
end
