function [pointillisticData, analysisParameters] = rainSTORM_scriptingVersion_dataImport(dataFileFullName, definedCameraSignalConversion)


[dataPath, dataName, extension] = fileparts(dataFileFullName);
if contains(dataName, '_trajs')
    dataName2 = strrep(dataName, '_trajs', '');
else
    dataName2 = strrep(dataName, '_locs', '');
end

infoFileFullName1 = [fullfile(dataPath, dataName), '_info.xml'];
infoFileFullName2 = [fullfile(dataPath, dataName2), '_info.xml'];

if isfile(infoFileFullName1)
    importedParameters = infoStruct_xml(infoFileFullName1);
else
    importedParameters = infoStruct_xml(infoFileFullName2);
end

analysisParameters = convertAnalysisParameters(importedParameters);

% overwrite the parametrs that could not be read out from the
% metadata with the default ones:
loadedCameraSignalConversion = analysisParameters.sharedParameters.cameraSignalConversion;
missingOnlyBoolean = true;
overwrittenCameraSignalConversion = imageStack_getConversionFactors.overwriteParameters(loadedCameraSignalConversion, definedCameraSignalConversion, missingOnlyBoolean);
analysisParameters.sharedParameters.cameraSignalConversion = overwrittenCameraSignalConversion;

analysisParameters.sharedParameters.originalDataPath = dataPath;
analysisParameters.sharedParameters.originalDataName = dataName;

% the tabular data is in the same format, no need to convert it
pointillisticData = pointillisticData_load.tabularData(dataFileFullName);

end

function analysisParameters = convertAnalysisParameters(importedParameters)

% TODO its is unfinished, I have no more motivation
% it does the basics....

evaluationParameters = struct();

evaluationParameters.dataType = 'localizationData';
evaluationParameters.dataType = 'concatenatedData';
evaluationParameters.note = '';

if isfield(importedParameters, 'acquisition')

    stackSize =  importedParameters.imageStack.stackSize;

    cameraSignalConversion.pixelSize_nm = importedParameters.acquisition.pixelSize_nm;
    cameraSignalConversion.exposureTime_ms = importedParameters.acquisition.exposureTime;
    cameraSignalConversion.frameInterval_ms = 1/importedParameters.acquisition.frameRate;
    cameraSignalConversion.countsPerPhoton = importedParameters.acquisition.countsPerPhoton;
    QE = importedParameters.acquisition.camera.readoutParams.QE;
    cameraSignalConversion.countsPerElectron = cameraSignalConversion.countsPerPhoton / QE;
    cameraSignalConversion.baseline_count = nan; % let it be, although it was 100 for every data analysis performed with this convention...

    ROI.x = [0, stackSize(1)];
    ROI.y = [0, stackSize(2)];
    ROI.unit = 'camera pixel length';
    frameRange = [1, stackSize(3)];

    convention.name = 'rainSTORM scripting version';
    convention.algorithm = '';
    convention.analyses = {};
    
    sharedParameters.stackSize = stackSize;
    sharedParameters.cameraSignalConversion = cameraSignalConversion;
    sharedParameters.ROI = ROI;
    sharedParameters.frameRange = frameRange;
    sharedParameters.convention = convention;

    importedParameters = rmfield(importedParameters, 'acquisition');
elseif isfield(importedParameters, 'imageStackReading')

    stackSize =  importedParameters.imageStackReading.metadata.stackSize;
    cameraSignalConversion.pixelSize_nm = importedParameters.imageStackReading.metadata.cameraSignalConversion.pixelSize_nm;
    cameraSignalConversion.exposureTime_ms = importedParameters.imageStackReading.metadata.cameraSignalConversion.exposureTime_ms;
    cameraSignalConversion.frameInterval_ms = importedParameters.imageStackReading.metadata.cameraSignalConversion.frameInterval_ms;
    cameraSignalConversion.countsPerPhoton = importedParameters.imageStackReading.metadata.cameraSignalConversion.countsPerPhoton;
    cameraSignalConversion.countsPerElectron = 1/importedParameters.imageStackReading.metadata.cameraSignalConversion.electronsPerCount;
    cameraSignalConversion.baseline_count = importedParameters.imageStackReading.metadata.cameraSignalConversion.baseline;
    
    ROI.x = [0, stackSize(1)];
    ROI.y = [0, stackSize(2)];
    ROI.unit = 'camera pixel length';
    frameRange = [1, stackSize(3)];
    
    convention.name = 'rainSTORM scripting version';
    convention.algorithm = '';
    convention.analyses = {};
    
    sharedParameters.stackSize = stackSize;
    sharedParameters.cameraSignalConversion = cameraSignalConversion;
    sharedParameters.ROI = ROI;
    sharedParameters.frameRange = frameRange;
    sharedParameters.convention = convention;

end

if isfield(importedParameters, 'imageStack')
    importedOperation = importedParameters.backgroundFiltering;
    imageStackReadingOperation = convertOperation(importedOperation, 'imageStack');
    importedParameters = rmfield(importedParameters, 'imageStack');
elseif isfield(importedParameters, 'imageStackReading')
    importedOperation = importedParameters.backgroundSubtraction;
    imageStackReadingOperation = convertOperation(importedOperation, 'imageStackReading');
    importedParameters = rmfield(importedParameters, 'imageStackReading');
end

if isfield(importedParameters, 'backgroundFiltering')
    importedOperation = importedParameters.backgroundFiltering;
    backgroundRemovalOperation = convertOperation(importedOperation, 'backgroundFiltering');
    importedParameters = rmfield(importedParameters, 'backgroundFiltering');
elseif isfield(importedParameters, 'backgroundSubtraction')
    importedOperation = importedParameters.backgroundSubtraction;
    backgroundRemovalOperation = convertOperation(importedOperation, 'backgroundSubtraction');
    importedParameters = rmfield(importedParameters, 'backgroundSubtraction');
end




if isfield(importedParameters, 'trajectoryFitting')
    importedCreationOperationName = 'trajectoryFitting';
    importedCreationOperationStruct = importedParameters.(importedCreationOperationName);
    mainCreationOperation = convertOperation(importedCreationOperationStruct, importedCreationOperationName);

    importedParameters = rmfield(importedParameters, 'trajectoryFitting');

    dataType = 'concatenatedData';
elseif isfield(importedParameters, 'localization')
    importedCreationOperationName = 'localization';
    importedCreationOperationStruct = importedParameters.(importedCreationOperationName);
    mainCreationOperation = convertOperation(importedCreationOperationStruct, importedCreationOperationName);

    importedParameters = rmfield(importedParameters, 'localization');

    dataType = 'localizationData';
else
    mainCreationOperation = struct();
end

remainedOperations = fieldnames(importedParameters);
processingOperations = {};
for idxOp = 1:numel(remainedOperations)
    operationName = remainedOperations{idxOp};

    convertedCreationOperationStruct = convertOperation(importedParameters.(operationName), operationName);
    % put the operaation into a cell array instead of a normal as, as the html
    % export does not work with normal struct arrays....
    processingOperations = {processingOperations, convertedCreationOperationStruct};
end


analysisParameters_imageStack.dataType = 'imageStack';
analysisParameters_imageStack.note = 'legacy rainSTORM scripting version localization data import';
analysisParameters_imageStack.creationOperation = {...
    imageStackReadingOperation
};
analysisParameters_imageStack.processingOperations = [...
    backgroundRemovalOperation];
analysisParameters_imageStack.derivativeDatas = {};

% the localization data is the upper in the hierarchy within the
% "analysisParameters" in case of the legacy rainSTORM
analysisParameters.dataType = dataType;
analysisParameters.note = 'legacy rainSTORM scripting version localization data import';
analysisParameters.creationOperation = {...
    mainCreationOperation
    };
analysisParameters.processingOperations = processingOperations;

analysisParameters.derivativeDatas = {analysisParameters_imageStack};
analysisParameters.sharedParameters = sharedParameters;


end

function convertedOperation = convertOperation(importedOperation, name)

    convertedOperation.operationType = name;
    convertedOperation.note = 'legacy rainSTORM scripting version localization data import';

    if isfield(importedOperation, 'method')
        convertedOperation.function =  importedOperation.method;
    elseif isfield(importedOperation, 'handleString')
        convertedOperation.function =  importedOperation.handleString;
    elseif isfield(importedOperation, 'algoName')
        convertedOperation.function =  importedOperation.algoName;
    else
        convertedOperation.function =  '';
    end
    
    if isfield(importedOperation, 'settings')
        convertedOperation.settings = importedOperation.settings;
    else
        convertedOperation.settings = importedOperation;
    end
    
    if isfield(importedOperation, 'metadata')
        convertedOperation.settings = importedOperation.metadata;
    else
        convertedOperation.settings = struct();
    end

end

function analysisParameters = infoStruct_xml(infoFileFullName)
    % Load the accompanying information of the data saed onto an
    % *.xml file into a structure variable.

    if ~isfile(infoFileFullName)
       error(['The *. xml info file to be loaded as a structure does not exist: ', infoFileFullName]) 
    end

    % this xml stuff is somewhat buggy:
    % disdards struct field with empty cells
    % if a struct elements has a 'ranSTORM' text, it will run
    % rainSTORM.m....
    infoStruct = xmlManagement.xml2struct(infoFileFullName );

    % extract the ecvaluation parameters
    analysisParameters = struct();
    if isfield(infoStruct, 'evaluationParameters')
        analysisParameters=infoStruct.evaluationParameters;
    elseif numel(fieldnames(infoStruct))>0
        warning('The "evaluationParameters" does not exist in the loaded info file. Check whether the correct info data was loaded.')
        fieldNames=fieldnames(infoStruct);
        analysisParameters=infoStruct.(fieldNames{1});
    else
        error(['The loaded *.json info file is empty: ',infoFileFullName])
    end


end