classdef rainSTORM_GUIsettings_astigmatic3D

    methods(Static)

        function availableMethods = methods()
            availableMethods = {...
                'sigma squared error';...
                'fit on ellipticity';
                'fit on sigmas'...
                };
        end

        function formulas = ellipticityFormulas()

          formulas = {'ratio'; 'symmetrical'; 'difference'; 'n.square difference'; 'n.difference'};

        end

        function operationSettings = settings(method)

            operationSettings.method = method;
            switch method
                case 'sigma squared error'
                    operationSettings.operationType='astigmatic axial position calculation';
                    operationSettings.note='rainSTORM''s default astigmatic3D settings';
                    operationSettings.functionName='rainSTORM_astigmatic3D';
                    operationSettings.settings.zBounds = struct(...
                        'name', 'z bounds',...
                        'description', 'Bounds within the Z positions should be determined.',...
                        'value', [-500, 500],...
                        'unit', 'nm');
                    operationSettings.settings.polynomialOrder = struct(...
                        'name', 'polinomial order',...
                        'description', 'Order of the polynomial to be fit on the calibration data.',...
                        'value', 4);
                    operationSettings.settings.resamplingNumber = struct(...
                        'name', 'resampling number',...
                        'description', 'Resample the fitted polynomial at a number of these points.',...
                        'value', 200);
                case 'fit on ellipticity'
                    operationSettings.type='astigmatic axial position calculation';
                    operationSettings.note='rainSTORM legacy''s default astigmatic3D settings';
                    operationSettings.functionName='rainSTORM_astigmatic3D';
                    operationSettings.settings.zBounds = struct(...
                        'name', 'z bounds',...
                        'description', 'Bounds within the Z positions should be determined.',...
                        'value', [-500, 500],...
                        'unit', 'nm');
                    operationSettings.settings.polynomialOrder = struct(...
                        'name', 'polinomial order',...
                        'description', 'Order of the polynomial to be fit on the calibration data.',...
                        'value', 4);
                    operationSettings.settings.formula = struct(...
                        'name', 'formula',...
                        'description', 'Formula for the ellipticity calculation.',...
                        'value', 'symmetrical');
                case 'fit on sigmas'
                    operationSettings.type='astigmatic axial position calculation';
                    operationSettings.note='rainSTORM legacy''s default astigmatic3D settings';
                    operationSettings.functionName='rainSTORM_astigmatic3D';
                    operationSettings.settings.zBounds = struct(...
                        'name', 'z bounds',...
                        'description', 'Bounds within the Z positions should be determined.',...
                        'value', [-500, 500],...
                        'unit', 'nm');
                    operationSettings.settings.polynomialOrder = struct(...
                        'name', 'polinomial order',...
                        'description', 'Order of the polynomial to be fit on the calibration data.',...
                        'value', 4);
                otherwise
                    error('Unknown rainSTORM astigmatic 3D method (%s) when choosing the default settings.', method)
            end

            operationSettings.settingsLinking(1).target='cameraSignalConversion';
            operationSettings.settingsLinking(1).sourceParameter='cameraSignalConversion';

        end

    end

end
