classdef rainSTORM_GUIsettings_clusterization

    methods(Static)

        function availableMethods = methods()
            availableMethods = {...
                'DBSCAN'...
                };
        end

        function operationSettings = settings(method)

            operationSettings.method = method;
            switch method
                case 'DBSCAN'
                    operationSettings.operationType='clusterization';
                    operationSettings.note='rainSTORM''s default clusterization settings';
                    operationSettings.functionName='rainSTORM_clusterAnalysis.clusterize';
                    operationSettings.settings.epsilon =  struct(...
                        'name', 'epsilon',...
                        'description', 'Radius of a neighborhood',...
                        'value', 20,...
                        'unit', 'nm');
                    operationSettings.settings.minPts = struct(...
                        'name', 'minPts',...
                        'description', 'Minimal neighbour number within epsilon to be a core cluster element',...
                        'value', 8);
                    operationSettings.settings.threeDimFlag = struct(...
                        'name', '3D flag',...
                        'description', 'Perform the DBSCAN in 3D',...
                        'value', false);
                    operationSettings.settings.zScaleFactor = struct(...
                        'name', 'Z scaling',...
                        'description', 'Scale the Z positions to account for the diffrent axial precision',...
                        'value', 0.5);
                otherwise
                    error('Unknown rainSTORM clusterization method (%s) when choosing the default settings.', method)
            end

            operationSettings.settingsLinking(1).target='cameraSignalConversion';
            operationSettings.settingsLinking(1).sourceParameter='cameraSignalConversion';
            operationSettings.settingsLinking(2).target='ROI';
            operationSettings.settingsLinking(2).sourceParameter='ROI';

        end

    end

end
