classdef rainSTORM_GUIsettings_concatenation

    methods(Static)

        function availableMethods = methods()
            availableMethods = {...
                'branching trajectories'...
                };
        end

        function operationSettings = settings(method)

            operationSettings.method = method;
            switch method
                case 'branching trajectories'
                    operationSettings.operationType='concatenation';
                    operationSettings.note='rainSTORM''s default concatenation settings';
                    operationSettings.functionName='rainSTORM_trajectoryFitting.perform';
                    operationSettings.settings.thresholdingMethod =  struct(...
                        'name', 'thresholding method',...
                        'description', 'Concatenate the localizations on consecutive frames if their distance is smaller than a given threshold.',...
                        'value', 'fixed distance');
                    operationSettings.settings.distThreshold_nm = struct(...
                        'name', 'threshold value in nm',...
                        'description', 'Value of the concatenation distance threshold.',...
                        'value', 50);
                    operationSettings.settings.ZPrecConst = struct(...
                        'name', 'Z threshold scaling',...
                        'description', 'Scale the threshold in the axial direction by this value.',...
                        'value', 2);
                    operationSettings.settings.maxNumberOfNoNewLocsInARow = struct('name', 'Max. empty frames', 'description', 'Maximum number of frames to be skipped  if no candidate found for concatenation.', 'value', 2);
                otherwise
                    error('Unknown rainSTORM concatenation method (%s) when choosing the default settings.', method)
            end

            operationSettings.settingsLinking(1).target='cameraPixelSize_nm';
            operationSettings.settingsLinking(1).sourceParameter='cameraSignalConversion.pixelSize_nm';

        end

    end

end
