classdef rainSTORM_GUIsettings_driftCorrection
    
    methods(Static)
       
        function avalibleMethods = methods()
            avalibleMethods = {...
                'fiducial marker';...
                'rainSTORM cross correlation';...
                'BaSDI'...
                };
        end
        
        function operationSettings = settings(method)
            % All the settings in the drift correction algorithms are hard
            % coded currently
            
            
            operationSettings.method = method;
            switch method
                case 'fiducial marker'
                    operationSettings.operationType='drift correction';
                    operationSettings.note='fiducial marker based drift correction';
                    operationSettings.functionName='driftCorrection.correct';
                    operationSettings.settings = struct();
                case 'rainSTORM cross correlation'
                    operationSettings.operationType='drift correction';
                    operationSettings.note='rainSTORM''s default, cross-correlation like drift correction';
                    operationSettings.functionName='driftCorrection.correct';
                    operationSettings.settings.maximalFrameStep = struct(...
                        'name', 'frame step',...
                        'description', 'Frame step for drift trajectory determination. ',...
                        'value', 1000);
                case 'BaSDI'
                    operationSettings.operationType='drift correction';
                    operationSettings.note='"Bayesian sample drift inference" drift correction';
                    operationSettings.functionName='driftCorrection.correct';
                    operationSettings.settings.nFrames = struct(...
                        'name', 'fram number',...
                        'description', 'Frame windowing number.',...
                        'value', 500);
                    operationSettings.settings.scaleFactor = struct(...
                        'name', '',...
                        'description', '',...
                        'value', 10);
                otherwise
                    error('Unknown rainSTORM visualization method: %s', method)
            end
            
            operationSettings.settingsLinking(1).target='frameRange';
            operationSettings.settingsLinking(1).sourceParameter='frameRange';
            
        end
        
    end

end