classdef rainSTORM_GUIsettings_filtering

    methods(Static)
    
        function avalibleMethods = methods()
            avalibleMethods = {...
                'rainSTORM default';...
                'image stack'...
                };
        end

        function operationSettings = settings(method)

            operationSettings.method = method;
            switch method
                case 'rainSTORM default'
                    operationSettings.operationType='pointillistic data filtering';
                    operationSettings.note='rainSTORM''s default filtering settings';
                    operationSettings.functionName='filteringOperation.filter';
                    operationSettings.settings = struct(...
                        'thresholds', [...
                        struct(...
                        'field', 'frame_idx',...
                        'bounds', [1 Inf],...
                        'unit', 'camera frame interval'),...
                        struct(...
                        'field', 'x_coord',...
                        'bounds', [-Inf Inf],...
                        'unit', 'camera pixel length'),...
                        struct(...
                        'field', 'y_coord',...
                        'bounds', [-Inf Inf],...
                        'unit', 'camera pixel length'),...
                        struct(...
                        'field', 'z_coord',...
                        'bounds', [-Inf Inf],...
                        'unit', 'camera pixel length'),...
                        struct(...
                        'field', 'std',...
                        'bounds', [0 40],...
                        'unit', 'nm'),...
                        struct(...
                        'field', 'std_x',...
                        'bounds', [0 40],...
                        'unit', 'nm'),...
                        struct(...
                        'field', 'std_y',...
                        'bounds', [0 40],...
                        'unit', 'nm'),...
                        struct(...
                        'field', 'sum_signal',...
                        'bounds', [500 Inf],...
                        'unit', 'camera count'),...
                        struct(...
                        'field', 'sig',...
                        'bounds', [0.7 1.5],...
                        'unit', 'camera pixel length'),...
                        struct(...
                        'field', 'sig_x',...
                        'bounds', [0.7 1.5],...
                        'unit', 'camera pixel length'),...
                        struct(...
                        'field', 'sig_y',...
                        'bounds', [0.7 1.5],...
                        'unit', 'camera pixel length'),...
                        struct(...
                        'field', 'res',...
                        'bounds', [0 0.5],...
                        'unit', '')...
                        ]);
                case 'image stack'
                    operationSettings.operationType='pointillistic data filtering';
                    operationSettings.note='filtering of the image ROI and frame range';
                    operationSettings.functionName='filteringOperation.filter';
                    operationSettings.settings = struct(...
                        'thresholds', [...
                        struct(...
                        'field', 'frame_idx',...
                        'bounds', [1 Inf],...
                        'unit', 'camera frame interval'),...
                        struct(...
                        'field', 'x_coord',...
                        'bounds', [-Inf Inf],...
                        'unit', 'nm'),...
                        struct(...
                        'field', 'y_coord',...
                        'bounds', [-Inf Inf],...
                        'unit', 'nm')...
                        ]);
                otherwise
                    error('Unknown rainSTORM filtering pre-defined settings: %s', method)
            end

            operationSettings.settingsLinking(1).target='originalDataConvention';
            operationSettings.settingsLinking(1).sourceParameter='convention';
            operationSettings.settingsLinking(2).target='stackSize';
            operationSettings.settingsLinking(2).sourceParameter='stackSize';
            operationSettings.settingsLinking(3).target='frameRange';
            operationSettings.settingsLinking(3).sourceParameter='frameRange';
            operationSettings.settingsLinking(4).target='ROI';
            operationSettings.settingsLinking(4).sourceParameter='ROI';
            operationSettings.settingsLinking(5).target='cameraSignalConversion';
            operationSettings.settingsLinking(5).sourceParameter='cameraSignalConversion';

        end

    end

end
