classdef rainSTORM_GUIsettings_localization
    
    methods(Static)
        
        function availableMethods = methods()
            availableMethods = {...
                'LS Gaussian 2D linear Bg';...
                'LS Gaussian 2D const Bg';...
                'LS Gaussian Halt3';...
                'LS Gaussian Thorough';...
                'Centre of Mass';...
                'LS Multi Gaussian 2D linear Bg';...
                'LS Multi Gaussian 2D const Bg';...
                'LS Astigmatic Gaussian 2D linear Bg';...
                'LS Astigmatic Gaussian 2D const Bg';...
                'LS Multi Astigmatic Gaussian 2D linear Bg'...
                };
        end
        
                
        
        function operationSettings = settings(locAlgoName)
            
            operationSettings.operationType='localization';
            operationSettings.note='rainSTORM''s default localization';
            operationSettings.functionName='rainSTORM_localize';
            operationSettings.method=locAlgoName;
            operationSettings.settingsLinking=struct([]);
            operationSettings.settingsLinking(1).target='cameraSignalConversion';
            operationSettings.settingsLinking(1).sourceParameter='cameraSignalConversion';
            
            switch locAlgoName
                case {  'LS Gaussian 2D linear Bg';...
                        'LS Gaussian 2D const Bg';...
                        'LS Gaussian Halt3';...
                        'LS Gaussian Thorough';...
                        'Centre of Mass'}
                    settings = gen_struct_1();
                case {  'LS Multi Gaussian 2D linear Bg';...
                        'LS Multi Gaussian 2D const Bg'}
                    settings = gen_struct_2();
                case 'Test Algo'
                    settings = gen_struct_3();
                case {  'LS Astigmatic Gaussian 2D linear Bg';...
                        'LS Astigmatic Gaussian 2D const Bg';...
                        'LS Multi Astigmatic Gaussian 2D linear Bg'}
                    settings = gen_struct_a();
                otherwise
                    error(['Unknown localization algorithm name: ', locAlgoName])
            end
            
            operationSettings.settings = settings;
            
        end
        
    end
    
end


function settings = gen_struct_1()
    settings=[];
    settings.ImageFilter = struct(...
        'value','Average',...
        'name','Image filter algorithm',...
        'description','Filter applied before candidate selection',...
        'options',{{'none', 'Average', 'Laplacian of Gaussian' ,'Determinant of Hessian' }},...
        'style','popup',...
        'type','text');
    settings.Thresh = struct(...
        'value',0,...
        'unit','camera count',...
        'name','ROI Candidate Threshold',...
        'description','Threshold to filter out ROI candidates with low signal. Peak pixel value of the identified spots on the filtered image.',...
        'style','edit',...
        'type','number');
    settings.Thresh2 = struct(...
        'value',0,...
        'name','ROI Candidate Relative Peak Value Threshold',...
        'description','Threshold ROI candidates with low peak value. Candidate will pass through if (peak value - min(roi)) > thresh*std(background)',...
        'style','edit',...
        'type','number');
    settings.allowSig = struct(...
        'value',[80 640],...
        'unit','nm',...
        'name','Allowed Sigma',...
        'description','Stop ROI fitting if iteration goes out of this range [min max].',...
        'style','edit',...
        'type','number');
    settings.allowX = struct(...
        'value',320,...
        'unit', 'nm',...
        'name','Allowed  Distance',...
        'description','Stop ROI fitting if iteration goes further than this value.',...
        'style','edit',...
        'type','number');
    settings.initSig = struct(...
        'value',200,...
        'unit', 'nm',...
        'name','Initial guess of PSF Sigma',...
        'description','The initial sigma value of PSF fitting.',...
        'style','edit',...
        'type','number');
    settings.maxIts = struct(...
        'value',6,...
        'name','Maximum Iterations',...
        'description','The maximum number of iterations of ROI fitting.',...
        'style','edit',...
        'type','number');
    settings.rad = struct(...
        'value',540,...
        'unit', 'nm',...
        'name','Radius of ROI',...
        'description','''round(Radius of ROI / camera pixel size)'' = 3 means that the area of interest for each spot is a 7x7 area.',...
        'style','edit',...
        'type','number');
    settings.tol = struct(...
        'value',0.5,...
        'name','Tolerance',...
        'description','Flag the fit as acceptable and save the fit result if the residue is below this value.',...
        'style','edit',...
        'type','number');
end

function settings = gen_struct_a()
    settings=[];
    settings.ImageFilter = struct(...
        'value','Average',...
        'name','Image filter algorithm',...
        'description','Filter applied before candidate selection',...
        'options',{{'none', 'Average', 'Laplacian of Gaussian' ,'Determinant of Hessian' }},...
        'style','popup',...
        'type','text');
    settings.Thresh = struct(...
        'value',0,...
        'unit', 'camera count',...
        'name','ROI Candidate Threshold',...
        'description','Filter out ROI candidates (identified spots on the filtered image) with peak pixel values smaller than the given threshold.',...
        'style','edit',...
        'type','number');
    settings.Thresh2 = struct(...
        'value',0,...
        'name','ROI Candidate Relative Peak Value Threshold',...
        'description','Threshold ROI candidates with low peak value. Candidate will pass through if (peak value - min(roi)) > thresh*std(background)',...
        'style','edit',...
        'type','number');
    settings.allowSig = struct(...
        'value',[80 640],...
        'unit', 'nm',...
        'name','Allowed Sigma',...
        'description','Stop ROI fitting if iteration goes out of this range [min max].',...
        'style','edit',...
        'type','number');
    settings.allowX = struct(...
        'value',320,...
        'unit', 'nm',...
        'name','Allowed  Distance',...
        'description','Stop ROI fitting if iteration goes further than this value.',...
        'style','edit',...
        'type','number');
    settings.initSig = struct(...
        'value',200,...
        'unit', 'nm',...
        'name','Initial guess of PSF Sigma',...
        'description','The initial sigma value of PSF fitting.',...
        'style','edit',...
        'type','number');
    settings.maxIts = struct(...
        'value',6,...
        'name','Maximum Iterations',...
        'description','The maximum number of iterations of ROI fitting.',...
        'style','edit',...
        'type','number');
    settings.prevSF = struct(...
        'value',5,...
        'name','Preview Scale Factor',...
        'description','Scale factor to render sum image, to have the same size as the super resolved image. Rounded to integer.',...
        'style','edit',...
        'type','number');
    settings.rad = struct(...
        'value',640,...
        'unit', 'nm',...
        'name','Radius of ROI',...
        'description','''round(Radius of ROI / camera pixel size)'' = 3 means that the area of interest for each spot is a 7x7 area.',...
        'style','edit',...
        'type','number');
    settings.tol = struct(...
        'value',0.5,...
        'name','Tolerance',...
        'description','Flag the fit as acceptable and save the fit result if the residue is below this value.',...
        'style','edit',...
        'type','number');
end

function settings = gen_struct_2()
    settings=[];
    settings.ImageFilter = struct(...
        'value','none',...
        'name','Image filter algorithm',...
        'description','Filter applied before candidate selection',...
        'options',{{'none', 'Average', 'Laplacian of Gaussian' ,'Determinant of Hessian' }},...
        'style','popup',...
        'type','text');
    settings.Thresh = struct(...
        'value',0,...
        'unit', 'camera count',...
        'name','ROI Candidate Threshold',...
        'description','Filter out ROI candidates (identified spots on the filtered image) with peak pixel values smaller than the given threshold.',...
        'style','edit',...
        'type','number');
    settings.Thresh2 = struct(...
        'value',4,...
        'name','ROI Candidate Relative Peak Value Threshold',...
        'description','Threshold ROI candidates with low peak value. Candidate will pass through if (peak value - min(roi)) > thresh*std(background)',...
        'style','edit',...
        'type','number');
    settings.allowSig = struct(...
        'value',[80 640],...
        'unit', 'nm',...
        'name','Allowed Sigma',...
        'description','Stop ROI fitting if iteration goes out of this range [min max].',...
        'style','edit',...
        'type','number');
    settings.allowX = struct(...
        'value',320,...
        'unit', 'nm',...
        'name','Allowed  Distance',...
        'description','Stop ROI fitting if iteration goes further than this value.',...
        'style','edit',...
        'type','number');
    settings.initSig = struct(...
        'value',200,...
        'unit', 'nm',...
        'name','Initial guess of PSF Sigma',...
        'description','The initial sigma value of PSF fitting.',...
        'style','edit',...
        'type','number');
    settings.maxIts = struct(...
        'value',6,...
        'name','Maximum Iterations',...
        'description','The maximum number of iterations of ROI fitting.',...
        'style','edit',...
        'type','number');
    settings.prevSF = struct(...
        'value',5,...
        'name','Preview Scale Factor',...
        'description','Scale factor to render sum image, to have the same size as the super resolved image. Rounded to integer.',...
        'style','edit',...
        'type','number');
    settings.rad = struct(...
        'value',640,...
        'unit', 'nm',...
        'name','Radius of ROI',...
        'description','''round(Radius of ROI / camera pixel size)'' = 3 means that the area of interest for each spot is a 7x7 area.',...
        'style','edit',...
        'type','number');
    settings.tol = struct(...
        'value',0.5,...
        'name','Tolerance',...
        'description','Flag the fit as acceptable and save the fit result if the residue is below this value.',...
        'style','edit',...
        'type','number');
end




function settings = gen_struct_3()

    settings=[];
    settings.Thresh = struct(...
        'value',0,...
        'name','ROI Candidate Threshold',...
        'description','Filter out ROI candidates (identified spots on the filtered image) with peak pixel values smaller than the given threshold.',...
        'type','number');
    settings.allowSig = struct(...
        'value',[0.5 3+1]*160,...
        'name','Allowed Sigma [nm]',...
        'description','Stop ROI fitting if iteration goes out of this range [min max]. [nm]',...
        'type','number');
    settings.allowX = struct(...
        'value',2*160,...
        'name','Allowed  Distance [nm]',...
        'description','Stop ROI fitting if iteration goes further than this value. [nm]',...
        'type','number');
    settings.initSig = struct(...
        'value',1.3*160,...
        'name','Initial guess of PSF Sigma [nm]',...
        'description','The initial sigma value of PSF fitting. [nm]',...
        'type','number');
    settings.maxIts = struct(...
        'value',6,...
        'name','Maximum Iterations',...
        'description','The maximum number of iterations of ROI fitting. [-]',...
        'type','number');
    settings.prevSF = struct(...
        'value',5,...
        'name','Preview Scale Factor [int]',...
        'description','Scale factor to render sum image, to have the same size as the super resolved image. [integer]',...
        'type','number');
    settings.rad = struct(...
        'value',3*160,...
        'name','Radius of ROI [nm]',...
        'description','''round(Radius of ROI / camera pixel size)'' = 3 means that the area of interest for each spot is a 7x7 area. [nm]',...
        'type','number');
    settings.tol = struct(...
        'value',0.5,...
        'name','Tolerance [-]',...
        'description','Flag the fit as acceptable and save the fit result if the residue is below this value. [-]',...
        'type','number');

    for idx_param = 1:5
        settings.(['Test',num2str(idx_param,'%2.2i')]) = struct(...
            'value',idx_param,...
            'name',['Test',num2str(idx_param,'%2.2i'),' [-]'],...
            'description',['Test ',num2str(idx_param),' this value. [-]'],...
            'type','number');
    end

end

