classdef rainSTORM_GUIsettings_pixelization
    
    methods(Static)
       
        function avalibleMethods = methods()
            avalibleMethods = {...
                'Simple Histogram';...
                'Jittered Histogram';...
                'Average Precision Image';...
                'Intensity Precision Image'...
                };
        end
        
        function operationSettings = settings(method)
            
            operationSettings.method = method;
            switch method
                case 'Simple Histogram'
                    operationSettings.operationType='pointillistic data pixelization';
                    operationSettings.note='rainSTORM''s default pixelization';
                    operationSettings.functionName='rainSTORM_pixelization';
                    operationSettings.settings = gen_struct_simple_hist();
                case 'Jittered Histogram'
                    operationSettings.operationType='pointillistic data pixelization';
                    operationSettings.note='more advanced and computation intensive pixelization';
                    operationSettings.functionName='rainSTORM_pixelization';
                    operationSettings.settings = gen_struct_JH();
                case 'Average Precision Image'
                    operationSettings.operationType='pointillistic data pixelization';
                    operationSettings.note='mean of localization precisions pixelization';
                    operationSettings.functionName='rainSTORM_pixelization';
                    operationSettings.settings = gen_struct_simple_hist();
                case 'Intensity Precision Image'
                    operationSettings.operationType='pointillistic data pixelization';
                    operationSettings.note='sum of intensity and precision ratio pixelization';
                    operationSettings.functionName='rainSTORM_pixelization';
                    operationSettings.settings = gen_struct_simple_hist();
                otherwise
                    error('Unknown rainSTORM pixelization algorithm: %s', method)
            end
            
            operationSettings.settingsLinking(1).target='cameraPixelSize_nm';
            operationSettings.settingsLinking(1).sourceParameter='cameraSignalConversion.pixelSize_nm';
            operationSettings.settingsLinking(2).target='stackSize';
            operationSettings.settingsLinking(2).sourceParameter='stackSize';
            
        end
        
    end

end

function settings = gen_struct_simple_hist()
settings=[];
settings.linMag = struct(...
    'value',8,...
    'name','Pixelization Scale Factor',...
    'description','Create this many super-res rows/cols per CCD row/column. [-]');
end

function settings = gen_struct_JH()
settings=[];
settings.jhLinMag_max = struct(...
    'value',8,...
    'name','Max. Recon. Scale Factor',...
    'description','Create this many super-res rows/cols per CCD row/column maximum. [-]');
settings.jhAlpha = struct(...
    'value',0.5,...
    'name','jhAlpha',...
    'description','See [Silverman, page 101 onwards]');
settings.jhArbitFactor = struct(...
    'value',0.85,...
    'name','jhArbitFactor',...
    'description','For tweaking the jittering (kernel) width. Try 1');
settings.jhFinesse = struct(...
    'value',0.5,...
    'name','jhFinesse',...
    'description','Tweaks the pixel width of reconstruction. Try 1');
settings.jhNJitters = struct(...
    'value',60,...
    'name','jhNJitters',...
    'description','Number of Jitters per localisation.');
settings.jhPilotCoarseness = struct(...
    'value',1,...
    'name','jhPilotCoarseness',...
    'description','To coarsen pilot estimate.');
settings.flagJHBlur = struct(...
    'value',1,...
    'name','flagJHBlur',...
    'description',' To blur pilot estimate by convolution w/ ones(3).');
end

% function settings = gen_struct_Trajectory_Fitting()
% settings=[];
% settings.linMag = struct(...
%     'value',8,...
%     'name','Pixelization Scale Factor',...
%     'description','Create this many super-res rows/cols per CCD row/column. [-]',...
%     'type','number');
% settings.r_acc = struct(...
%     'value',150,...
%     'inverted',0,...
%     'name','Acceptance Radius',...
%     'description','The max distance of two localizations to consider them in the same trajectory. [nm]',...
%     'type','number');
% settings.x_coord = struct(...
%     'value',[-Inf Inf],...
%     'inverted',0,...
%     'name','X coordinate',...
%     'description','The range of localization coordinates in the x direction. [pix]',...
%     'type','number');
% settings.y_coord = struct(...
%     'value',[-Inf Inf],...
%     'inverted',0,...
%     'name','Y coordinate',...
%     'description','The range of localization coordinates in the x direction. [pix]',...
%     'type','number');
% end
%
% function settings = gen_struct_ellipticity()
% settings=[];
% settings.linMag = struct(...
%     'value',8,...
%     'name','Pixelization Scale Factor',...
%     'description','Create this many super-res rows/cols per CCD row/column. [-]',...
%     'type','number');
% settings.colourmap = struct(...
%     'value',[0.5 1.5],...
%     'name','Range of the colourmap',...
%     'description','The range of the ellipticity colourmap',...
%     'type','number');
% end
