classdef rainSTORM_GUIsettings_precision

    methods(Static)
    
        function avalibleMethods = methods()
            avalibleMethods = {...
                'center of mass';...
                'Thompson'...
                'Mortensen, Gaussian mask estimation'...
                'DeSantis'...
                };
        end

        function operationSettings = settings(method)

            operationSettings.method = method;
            switch method
                case 'center of mass'
                    operationSettings.operationType='localization precision estimation';
                    operationSettings.note='estimation for center of mass algorithms';
                    operationSettings.functionName='rainSTORM_precision';
                    operationSettings.settings = struct();
                case 'Thompson'
                    operationSettings.operationType='localization precision estimation';
                    operationSettings.note='legacy rainSTORM''s default algorithm';
                    operationSettings.functionName='rainSTORM_precision';
                    operationSettings.settings = struct();
                case 'Mortensen, Gaussian mask estimation'
                    operationSettings.operationType='localization precision estimation';
                    operationSettings.note='rainSTORM''s default algorithm';
                    operationSettings.functionName='rainSTORM_precision';
                    operationSettings.settings = struct();
                case 'DeSantis'
                    operationSettings.operationType='localization precision estimation';
                    operationSettings.note='formula for astigmatic PSF';
                    operationSettings.functionName='rainSTORM_precision';
                    operationSettings.settings = struct();
                otherwise
                    error('Unknown rainSTORM filtering pre-defined settings: %s', method)
            end

            operationSettings.settingsLinking(1).target='countsPerElectron';
            operationSettings.settingsLinking(1).sourceParameter='cameraSignalConversion.countsPerElectron';

        end

    end

end
