classdef rainSTORM_GUIsettings_visualization
    
    methods(Static)
       
        function avalibleMethods = methods()
            avalibleMethods = {...
                'fixed contrast';...
                'percentile saturation';...
                'percentile of non-zeros saturation'...
                };
        end
        
        function operationSettings = settings(method)
            
            operationSettings.method = method;
            switch method
                case 'fixed contrast'
                    operationSettings.operationType='super-resolution image visualization';
                    operationSettings.note='legacy rainSTORM''s default visualization';
                    operationSettings.functionName='rainSTORM_display';
                    operationSettings.settings.colormapName=struct(...
                        'name', 'colormap name',...
                        'description', 'The colormap to be used.',...
                        'value', 'Hot');
                    operationSettings.settings.colormapContrastRange = struct(...
                        'name', 'contrast range [counts]',...
                        'description', 'Pixel value range of the colormap.',...
                        'value', [0,20]);
                    operationSettings.settings.colorbarFlag = struct(...
                        'name', 'show colorbar',...
                        'description', 'Whether to show the colorbar beside the figure.',...
                        'value', false);
                    operationSettings.settings.scalebarFlag = struct(...
                        'name', 'show scalebar',...
                        'description', 'Whether to show the 1 um sized scalebar on the figure.',...
                        'value', true);
                    operationSettings.settings.scalebarColor = struct(...
                        'name', 'scalebar color',...
                        'description', 'Color of the salebar',...
                        'value', 'white');
                    operationSettings.settingsLinking=struct([]);
                case 'percentile saturation'
                    operationSettings.operationType='super-resolved image visualization';
                    operationSettings.note='alternative visualization method';
                    operationSettings.functionName='rainSTORM_display';
                    operationSettings.settings.colormapName=struct(...
                        'name','colormap name',...
                        'description', 'The colormap to be used.',...
                        'value', 'Hot');
                    operationSettings.settings.saturatedPercentage = struct(...
                        'name', 'saturated percentile',...
                        'description', 'Percentage of pixels to be saturated when setting the colormap.',...
                        'value', 0.01);
                    operationSettings.settings.colorbarFlag = struct(...
                        'name', 'show colorbar',...
                        'description', 'Whether to show the colorbar beside the figure.',...
                        'value', false);
                    operationSettings.settings.scalebarFlag = struct(...
                        'name', 'show scalebar',...
                        'description', 'Whether to show the 1 um sized scalebar on the figure.',...
                        'value', true);
                    operationSettings.settings.scalebarColor = struct(...
                        'name', 'scalebar color',...
                        'description', 'Color of the salebar',...
                        'value', 'white');
                case 'percentile of non-zeros saturation'
                    operationSettings.operationType='super-resolved image visualization';
                    operationSettings.note='rainSTORM''s default visualization';
                    operationSettings.functionName='rainSTORM_display';
                    operationSettings.settings.colormapName=struct(...
                        'name', 'colormap name',...
                        'description', 'The colormap to be used.',...
                        'value', 'Hot');
                    operationSettings.settings.saturatedPercentage = struct(...
                        'name', 'saturated percentile',...
                        'description', 'Percentage of non-zero pixels to be saturated when setting the colormap',...
                        'value', 0.1);
                    operationSettings.settings.colorbarFlag = struct(...
                        'name', 'show colorbar',...
                        'description', 'Whether to show the colorbar beside the figure.',...
                        'value', false);
                    operationSettings.settings.scalebarFlag = struct(...
                        'name', 'show scalebar',...
                        'description', 'Whether to show the 1 um sized scalebar on the figure.',...
                        'value', true);
                    operationSettings.settings.scalebarColor = struct(...
                        'name', 'scalebar color',...
                        'description', 'Color of the salebar',...
                        'value', 'white');
                otherwise
                    error('Unknown rainSTORM visualization method: %s', method)
            end
            
            operationSettings.settingsLinking(1).target='cameraSignalConversion';
            operationSettings.settingsLinking(1).sourceParameter='cameraSignalConversion';
            operationSettings.settingsLinking(2).target='ROI_bounds';
            operationSettings.settingsLinking(2).sourceParameter='ROI';
            
        end
        
    end

end