function cameraSignalConversionParameters = rainSTORM_settings_cameraSignalConversion(cameraSettingsName)

switch cameraSettingsName
    case 'iXon897'
        
        cameraSignalConversionParameters = struct(...
            'pixelSize', struct(...
                'name', 'Pixel size',...
                'value', 160,...
                'unit', 'nm',...
                'description', 'Camera pixel length/pitch in the object plane.'),...
            'exposureTime', struct(...
                'name', 'Exposure',...
                'value', 30,...
                'unit', 'ms',...
                'description', 'Exposure time of the camera frames.'),...
            'frameInterval', struct(...
                'name', 'Frame interval',...
                'value', 30.9,...
                'unit', 'ms',...
                'description', 'Time interval between the subsequent camera frames.'),...
            'countsPerElectron', struct(...
                'name', 'Counts/electron',...
                'value', 100/67.8,...
                'description', 'Number of camera counts produced by a single photoelectron.'),...
            'countsPerPhoton', struct(...
                'name', 'Counts/photon',...
                'value', 0.92 * 100/67.8,...
                'description', 'Number of camera counts produced by a single photon.'),...
            'baseline', struct(...
                'name', 'Baseline',...
                'value', 100,...
                'unit', 'camera count',...
                'description', 'Offset of the camera signal, i.e. the expected signal value of a totally dark acquisition.')...
            );
        
    otherwise
        error('Unknown camera settings name for the predefined camera signal conversion parameters: %s.', cameraSettingsName);
end

end

